/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.spd.obisplugin.util;

import java.util.ArrayList;
import java.util.List;
import org.gcube.data.spd.plugin.fwk.model.CommonName;
import org.gcube.data.spd.plugin.fwk.model.DataProvider;
import org.gcube.data.spd.plugin.fwk.model.DataSet;
import org.gcube.data.spd.plugin.fwk.model.Product;
import org.gcube.data.spd.plugin.fwk.model.ResultItem;
import org.gcube.data.spd.plugin.fwk.model.Taxon;

public class Util {
    public static ResultItem cloneResultItem(ResultItem item) {
        if (item == null) {
            return null;
        }
        ResultItem clone = new ResultItem(item.getId(), item.getScientificName());
        clone.setCitation(item.getCitation());
        clone.setCommonNames(Util.cloneCommonName(item.getCommonNames()));
        clone.setCredits(item.getCredits());
        clone.setDataSet(Util.cloneDataSet(item.getDataSet()));
        clone.setParent(Util.cloneTaxon(item.getParent()));
        clone.setProducts(Util.cloneProducts(item.getProducts()));
        clone.setProvider(item.getProvider());
        clone.setRank(item.getRank());
        clone.setScientificName(item.getScientificName());
        return clone;
    }

    protected static List<CommonName> cloneCommonName(List<CommonName> commonNames) {
        if (commonNames == null) {
            return null;
        }
        ArrayList<CommonName> clones = new ArrayList<CommonName>(commonNames.size());
        for (CommonName commonName : commonNames) {
            clones.add(Util.cloneCommonName(commonName));
        }
        return clones;
    }

    protected static CommonName cloneCommonName(CommonName commonName) {
        if (commonName == null) {
            return null;
        }
        return new CommonName(commonName.getLanguage(), commonName.getName());
    }

    protected static DataSet cloneDataSet(DataSet dataSet) {
        if (dataSet == null) {
            return null;
        }
        DataSet clone = new DataSet(dataSet.getId());
        clone.setCitation(dataSet.getCitation());
        clone.setName(dataSet.getName());
        clone.setDataProvider(Util.cloneDataProvider(dataSet.getDataProvider()));
        return clone;
    }

    protected static DataProvider cloneDataProvider(DataProvider dataProvider) {
        if (dataProvider == null) {
            return null;
        }
        DataProvider clone = new DataProvider(dataProvider.getId());
        clone.setName(dataProvider.getName());
        return clone;
    }

    protected static Taxon cloneTaxon(Taxon taxon) {
        if (taxon == null) {
            return null;
        }
        Taxon clone = new Taxon(taxon.getId(), taxon.getScientificName());
        clone.setCitation(taxon.getCitation());
        clone.setRank(taxon.getRank());
        clone.setScientificName(taxon.getScientificName());
        clone.setParent(Util.cloneTaxon(taxon.getParent()));
        return clone;
    }

    protected static List<Product> cloneProducts(List<Product> products) {
        if (products == null) {
            return null;
        }
        ArrayList<Product> clones = new ArrayList<Product>(products.size());
        for (Product product : products) {
            clones.add(Util.cloneProduct(product));
        }
        return clones;
    }

    protected static Product cloneProduct(Product product) {
        if (product == null) {
            return null;
        }
        Product clone = new Product(product.getType(), product.getKey());
        clone.setCount(product.getCount());
        return clone;
    }
}

