/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.spd.ncbi;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import org.gcube.data.spd.model.CommonName;
import org.gcube.data.spd.ncbi.connection.ConnectionPool;
import org.gcube.data.spd.ncbi.connection.ConnectionPoolException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Utils {
    static Logger logger = LoggerFactory.getLogger(Utils.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean SQLTableExists(String tableName) {
        boolean exists = false;
        ResultSet rs = null;
        ConnectionPool pool = null;
        Connection con = null;
        try {
            pool = ConnectionPool.getConnectionPool();
            con = pool.getConnection();
            Statement statement = con.createStatement();
            String sqlText = "SELECT tables.table_name FROM information_schema.tables WHERE table_name = '" + tableName + "'";
            rs = statement.executeQuery(sqlText);
            if (rs.next()) {
                exists = true;
                logger.trace(tableName + " exists");
            } else {
                exists = false;
                logger.trace(tableName + " does not exist");
            }
        }
        catch (SQLException e) {
            logger.error("SQLException", (Throwable)e);
        }
        catch (ConnectionPoolException e) {
            logger.error("ConnectionPoolException", (Throwable)e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException e) {
                logger.error("SQLException", (Throwable)e);
            }
            if (pool != null && con != null) {
                pool.releaseConnection(con);
            }
        }
        return exists;
    }

    public static String getOriginalId(String id) {
        String originalID = null;
        String[] originalId = null;
        if (id != null && (originalId = id.split("-")).length > 0) {
            originalID = originalId[0];
        }
        return originalID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String setAuthorship(String idPost, String scName) {
        String id = null;
        try {
            id = Utils.getOriginalId(idPost);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            id = idPost;
        }
        String authors = null;
        ConnectionPool pool = null;
        Connection con = null;
        try {
            pool = ConnectionPool.getConnectionPool();
            con = pool.getConnection();
            Statement statement = con.createStatement();
            ResultSet rs = statement.executeQuery("select name_txt from names where name_class='authority' and tax_id = " + id);
            if (rs.getFetchSize() > 0) {
                int authorLenght = 0;
                int scNameLenght = 0;
                while (rs.next()) {
                    String au;
                    Boolean flag;
                    String author = rs.getString(1);
                    if (author == null || (authorLenght = author.length()) <= (scNameLenght = scName.length()) + 3 || !(flag = Boolean.valueOf(scName.equals(author.substring(0, scNameLenght)))).booleanValue() || !(au = author.substring(scNameLenght + 1, authorLenght)).startsWith("(") && !Character.isUpperCase(au.charAt(0))) continue;
                    authors = au;
                }
                rs.close();
            }
        }
        catch (SQLException sqlExcept) {
            logger.error("sql Error", (Throwable)sqlExcept);
        }
        catch (Throwable e) {
            logger.error("general Error", e);
        }
        finally {
            if (pool != null && con != null) {
                pool.releaseConnection(con);
            }
        }
        return authors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long lastupdate() {
        ConnectionPool pool = null;
        Connection con = null;
        ResultSet results = null;
        long nextUpdate = 0L;
        try {
            pool = ConnectionPool.getConnectionPool();
            con = pool.getConnection();
            Statement statement = con.createStatement();
            String query = "select date from updates where id= (select max(id) from updates)";
            results = statement.executeQuery(query);
            java.sql.Date lastUpdate = null;
            if (results.next()) {
                lastUpdate = results.getDate(1);
                Date date = new Date();
                long days = date.getTime() - lastUpdate.getTime();
                if (days < 2592000000L) {
                    long l = 2592000000L - days;
                    return l;
                }
            }
        }
        catch (SQLException e) {
            logger.error("SQLException", (Throwable)e);
        }
        catch (ConnectionPoolException e) {
            logger.error("ConnectionPoolException", (Throwable)e);
        }
        finally {
            if (pool != null && con != null) {
                pool.releaseConnection(con);
            }
            try {
                if (results != null) {
                    results.close();
                }
            }
            catch (SQLException ex) {
                logger.error("sql Error", (Throwable)ex);
            }
        }
        return nextUpdate;
    }

    public static String nextUpdateDate(long input) {
        Date date = new Date(input);
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        return dateFormat.format(date);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getCitation(String idPost) {
        String id = null;
        ArrayList<String> citation = new ArrayList<String>();
        try {
            id = Utils.getOriginalId(idPost);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            id = idPost;
        }
        ConnectionPool pool = null;
        Connection con = null;
        try {
            pool = ConnectionPool.getConnectionPool();
            con = pool.getConnection();
            Statement statement = con.createStatement();
            ResultSet rs = statement.executeQuery("select distinct(cit_id) from citation where tax_id = " + id);
            if (rs != null) {
                while (rs.next()) {
                    int cit_id = rs.getInt(1);
                    String cit = Utils.createDD(cit_id);
                    if (cit == null) continue;
                    citation.add(cit);
                }
                rs.close();
            }
        }
        catch (SQLException sqlExcept) {
            logger.error("sql Error", (Throwable)sqlExcept);
        }
        catch (ConnectionPoolException e) {
            logger.error("ConnectionPoolException", (Throwable)e);
        }
        finally {
            if (pool != null && con != null) {
                pool.releaseConnection(con);
            }
        }
        return citation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String createDD(int cit_id) {
        StringBuilder cit = new StringBuilder();
        ConnectionPool pool = null;
        Connection con = null;
        try {
            pool = ConnectionPool.getConnectionPool();
            con = pool.getConnection();
            Statement statement = con.createStatement();
            ResultSet rs = statement.executeQuery("select cit_key, url, text from citations where cit_id = " + cit_id);
            if (rs != null) {
                while (rs.next()) {
                    cit.append(rs.getString(1));
                    cit.append(", ");
                    cit.append(rs.getString(2));
                    cit.append(", ");
                    cit.append(rs.getString(3));
                }
                rs.close();
            }
        }
        catch (SQLException sqlExcept) {
            logger.error("sql Error", (Throwable)sqlExcept);
        }
        catch (ConnectionPoolException e) {
            logger.error("ConnectionPoolException", (Throwable)e);
        }
        finally {
            if (pool != null && con != null) {
                pool.releaseConnection(con);
            }
        }
        return cit.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ResultSet getListScientificNameID(String scientificName) {
        ResultSet rs = null;
        ConnectionPool pool = null;
        Connection con = null;
        try {
            pool = ConnectionPool.getConnectionPool();
            con = pool.getConnection();
            Statement statement = con.createStatement();
            rs = statement.executeQuery("select distinct(tax_id) from names where name_class = 'scientific name' and UPPER(name_txt) like UPPER('%" + scientificName + "%')");
        }
        catch (SQLException sqlExcept) {
            logger.error("sql Error", (Throwable)sqlExcept);
        }
        catch (ConnectionPoolException e) {
            logger.error("ConnectionPoolException", (Throwable)e);
        }
        finally {
            if (pool != null && con != null) {
                pool.releaseConnection(con);
            }
        }
        return rs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<CommonName> getCommonNames(String idPost) {
        ArrayList<CommonName> commonNames = null;
        String id = null;
        try {
            id = Utils.getOriginalId(idPost);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            id = idPost;
        }
        if (id != null) {
            commonNames = new ArrayList<CommonName>();
            String language = "English";
            ConnectionPool pool = null;
            Connection con = null;
            try {
                pool = ConnectionPool.getConnectionPool();
                con = pool.getConnection();
                Statement statement = con.createStatement();
                ResultSet rs = statement.executeQuery("select name_txt from names where name_class = 'common name' and tax_id = " + id);
                if (rs != null) {
                    while (rs.next()) {
                        String name = rs.getString(1);
                        CommonName a = new CommonName(language, name);
                        commonNames.add(a);
                    }
                    rs.close();
                }
            }
            catch (SQLException sqlExcept) {
                logger.error("sql Error", (Throwable)sqlExcept);
            }
            catch (Throwable e) {
                logger.error("general Error", e);
            }
            finally {
                if (pool != null && con != null) {
                    pool.releaseConnection(con);
                }
            }
        }
        return commonNames;
    }

    public static String createDate() {
        Calendar now = Calendar.getInstance();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        String date = format.format(now.getTime());
        return date;
    }

    public static String createCitation() {
        StringBuilder cit = new StringBuilder();
        cit.append("Accessed through: The National Center for Biotechnology Information at http://www.ncbi.nlm.nih.gov/ on ");
        cit.append(Utils.createDate());
        return cit.toString();
    }

    public static String createCredits() {
        String cred = "This information object has been generated via the Species Product Discovery service on XDATEX by interfacing with The National Center for Biotechnology Information (http://www.ncbi.nlm.nih.gov/)";
        cred.replace("XDATEX", Utils.createDate());
        return cred;
    }
}

