/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.spd.ncbi.capabilities;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.data.spd.model.Condition;
import org.gcube.data.spd.model.Conditions;
import org.gcube.data.spd.model.exceptions.ExternalRepositoryException;
import org.gcube.data.spd.model.exceptions.IdNotValidException;
import org.gcube.data.spd.model.exceptions.MethodNotSupportedException;
import org.gcube.data.spd.model.products.TaxonomyItem;
import org.gcube.data.spd.model.products.TaxonomyStatus;
import org.gcube.data.spd.model.util.ElementProperty;
import org.gcube.data.spd.ncbi.Utils;
import org.gcube.data.spd.ncbi.connection.ConnectionPool;
import org.gcube.data.spd.plugin.fwk.capabilities.ClassificationCapability;
import org.gcube.data.spd.plugin.fwk.writers.ClosableWriter;
import org.gcube.data.spd.plugin.fwk.writers.ObjectWriter;

public class ClassificationCapabilityImpl
extends ClassificationCapability {
    GCUBELog logger = new GCUBELog(ClassificationCapabilityImpl.class);

    public Set<Conditions> getSupportedProperties() {
        return Collections.emptySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getSynonymnsById(ObjectWriter<TaxonomyItem> writer, String idPost) throws IdNotValidException, MethodNotSupportedException, ExternalRepositoryException {
        block21: {
            this.logger.trace((Object)"getSynonimnsByIds in NCBI...");
            String id = null;
            try {
                id = Utils.getOriginalId(idPost);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                id = idPost;
            }
            ResultSet rs = null;
            try {
                rs = this.getRSSynonyms(id);
                if (rs == null) break block21;
                int count = 0;
                while (rs.next()) {
                    String tax_id = rs.getString(1) + "-" + ++count;
                    String ScName = rs.getString(2);
                    String rank = rs.getString(3);
                    String idParent = rs.getString(4);
                    String status = rs.getString(5);
                    TaxonomyItem item = null;
                    try {
                        item = this.createTaxonomyItem(tax_id, ScName, rank, idParent, status, true);
                    }
                    catch (Exception e) {
                        this.logger.error((Object)"general Error", (Throwable)e);
                    }
                    if (item == null) continue;
                    writer.write((Object)item);
                }
            }
            catch (SQLException sqlExcept) {
                this.logger.error((Object)"sql Error", (Throwable)sqlExcept);
            }
            catch (Throwable e) {
                this.logger.error((Object)"general Error", e);
            }
            finally {
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (SQLException e) {
                        this.logger.error((Object)"sql Error", (Throwable)e);
                    }
                }
            }
        }
        this.logger.trace((Object)"getSynonimnsByIds finished in NCBI");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResultSet getRSSynonyms(String id) {
        ConnectionPool pool = null;
        Connection con = null;
        ResultSet rs = null;
        PreparedStatement stmt = null;
        try {
            pool = ConnectionPool.getConnectionPool();
            con = pool.getConnection();
            String query = "select a.tax_id, b.name_txt, a.rank, a.parent_tax_id, b.name_class from nodes as a NATURAL JOIN names as b where b.name_class = 'synonym' and CAST(a.tax_id as TEXT) like ?";
            ArrayList<String> terms = new ArrayList<String>();
            terms.add(id);
            rs = pool.selectPrestatement(query, terms, stmt);
        }
        catch (Throwable e) {
            this.logger.error((Object)"general Error", e);
        }
        finally {
            if (pool != null && con != null) {
                pool.releaseConnection(con);
            }
        }
        return rs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TaxonomyItem createTaxonomyItem(String id, String ScName, String rank, String idParent, String status, Boolean flag) throws SQLException {
        TaxonomyItem item = new TaxonomyItem(id);
        item.setScientificName(ScName);
        item.setCommonNames(Utils.getCommonNames(id));
        item.setStatus(this.setTaxonomicStatus(status));
        item.setCredits(Utils.createCredits());
        item.setCitation(Utils.createCitation());
        item.setAuthor(Utils.setAuthorship(id, ScName));
        List<String> citation = null;
        try {
            citation = Utils.getCitation(id);
            for (String c : citation) {
                ElementProperty property = new ElementProperty("Comments and References", c);
                item.addProperty(property);
            }
        }
        finally {
            if (citation != null) {
                citation.clear();
            }
        }
        if (!rank.equals("no rank")) {
            item.setRank(rank);
        }
        if (flag.booleanValue() && idParent != null && !idParent.equals("1") && !rank.equals("kingdom")) {
            try {
                item.setParent(this.retrieveTaxonById(idParent));
            }
            catch (IdNotValidException e) {
                this.logger.trace((Object)"Id not valid", (Throwable)e);
            }
        } else {
            item.setParent(null);
        }
        return item;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TaxonomyItem> retrieveTaxonChildsByTaxonId(String idPost) {
        String id = null;
        try {
            id = Utils.getOriginalId(idPost);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            id = idPost;
        }
        this.logger.trace((Object)("retrieveTaxonChildsByTaxonId " + id));
        ArrayList<TaxonomyItem> list = new ArrayList<TaxonomyItem>();
        ResultSet rs = null;
        try {
            rs = this.retrieveRSChilds(id);
            if (rs != null) {
                int count = 0;
                while (rs.next()) {
                    String tax_id = rs.getString(1) + "-" + ++count;
                    String ScName = rs.getString(2);
                    String rank = rs.getString(3);
                    String idParent = rs.getString(4);
                    String status = rs.getString(5);
                    TaxonomyItem tax = this.createTaxonomyItem(tax_id, ScName, rank, idParent, status, false);
                    list.add(tax);
                }
            }
        }
        catch (SQLException sqlExcept) {
            this.logger.error((Object)"sql Error", (Throwable)sqlExcept);
        }
        catch (Throwable e) {
            this.logger.error((Object)"general Error", e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    this.logger.error((Object)"sql Error", (Throwable)e);
                }
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResultSet retrieveRSChilds(String id) {
        ConnectionPool pool = null;
        Connection con = null;
        ResultSet rs = null;
        PreparedStatement stmt = null;
        try {
            pool = ConnectionPool.getConnectionPool();
            con = pool.getConnection();
            String query = "select a.tax_id, b.name_txt, a.rank, a.parent_tax_id, b.name_class from nodes as a NATURAL JOIN names as b where CAST(a.parent_tax_id as TEXT) like ?";
            ArrayList<String> terms = new ArrayList<String>();
            terms.add(id);
            rs = pool.selectPrestatement(query, terms, stmt);
        }
        catch (Throwable e) {
            this.logger.error((Object)"general Error", e);
        }
        finally {
            if (pool != null && con != null) {
                pool.releaseConnection(con);
            }
        }
        return rs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResultSet getDistinctIds(String name, String type) {
        ConnectionPool pool = null;
        Connection con = null;
        ResultSet rs = null;
        PreparedStatement stmt = null;
        try {
            pool = ConnectionPool.getConnectionPool();
            con = pool.getConnection();
            String query = "select distinct(tax_id) from names where name_class = (?) and UPPER(name_txt) like UPPER(?)";
            ArrayList<String> terms = new ArrayList<String>();
            terms.add(type);
            terms.add("%" + name + "%");
            rs = pool.selectPrestatement(query, terms, stmt);
        }
        catch (Throwable e) {
            this.logger.error((Object)"general Error", e);
        }
        finally {
            if (pool != null && con != null) {
                pool.releaseConnection(con);
            }
        }
        return rs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void searchByScientificName(String word, ObjectWriter<TaxonomyItem> writer, Condition ... properties) {
        block16: {
            ResultSet listIds = null;
            try {
                this.logger.trace((Object)("Retrive Taxa By Scientific Name " + word));
                listIds = this.getDistinctIds(word, "scientific name");
                if (listIds == null) break block16;
                String id = null;
                while (listIds.next()) {
                    id = listIds.getString(1);
                    TaxonomyItem item = null;
                    try {
                        item = this.retrieveTaxonById(id);
                    }
                    catch (Exception e) {
                        this.logger.error((Object)"Error", (Throwable)e);
                    }
                    if (item != null && writer.isAlive()) {
                        writer.write((Object)item);
                        continue;
                    }
                    break;
                }
            }
            catch (SQLException e) {
                this.logger.error((Object)"sql Error", (Throwable)e);
            }
            finally {
                if (listIds != null) {
                    try {
                        listIds.close();
                    }
                    catch (SQLException e) {
                        this.logger.error((Object)"sql Error", (Throwable)e);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void retrieveTaxonByIds(Iterator<String> ids, ClosableWriter<TaxonomyItem> writer) {
        try {
            while (ids.hasNext()) {
                String id = null;
                try {
                    id = Utils.getOriginalId(ids.next());
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    id = ids.next();
                }
                TaxonomyItem item = this.retrieveTaxonById(id);
                if (item != null && writer.isAlive()) {
                    writer.write((Object)item);
                    continue;
                }
                break;
            }
        }
        catch (Throwable e) {
            this.logger.error((Object)"general Error", e);
        }
        finally {
            writer.close();
        }
    }

    private TaxonomyStatus setTaxonomicStatus(String status) {
        TaxonomyStatus tax = status != null ? (status.equals("scientific name") ? new TaxonomyStatus(status, TaxonomyStatus.Status.ACCEPTED) : new TaxonomyStatus(status, TaxonomyStatus.Status.UNKNOWN)) : new TaxonomyStatus(status, TaxonomyStatus.Status.UNKNOWN);
        return tax;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TaxonomyItem retrieveTaxonById(String idPost) throws IdNotValidException {
        String id = null;
        try {
            id = Utils.getOriginalId(idPost);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            id = idPost;
        }
        TaxonomyItem item = null;
        ResultSet rs = null;
        try {
            rs = this.createRSbyID(id);
            if (rs != null && rs.next()) {
                String tax_id = rs.getString(1);
                String name_txt = rs.getString(2);
                String rank = rs.getString(3);
                String parent_tax_id = rs.getString(4);
                String name_class = rs.getString(5);
                item = this.createTaxonomyItem(tax_id, name_txt, rank, parent_tax_id, name_class, true);
            }
        }
        catch (SQLException sqlExcept) {
            this.logger.error((Object)"sql Error", (Throwable)sqlExcept);
        }
        catch (Throwable e) {
            this.logger.error((Object)"general Error", e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    this.logger.error((Object)"sql Error", (Throwable)e);
                }
            }
        }
        return item;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResultSet createRSbyID(String id) {
        ConnectionPool pool = null;
        Connection con = null;
        ResultSet rs = null;
        PreparedStatement stmt = null;
        try {
            pool = ConnectionPool.getConnectionPool();
            con = pool.getConnection();
            String query = "select a.tax_id, b.name_txt, a.rank, a.parent_tax_id, b.name_class from nodes as a NATURAL JOIN names as b where b.name_class = 'scientific name' and CAST(a.tax_id as TEXT) like ?";
            ArrayList<String> terms = new ArrayList<String>();
            terms.add(id);
            rs = pool.selectPrestatement(query, terms, stmt);
        }
        catch (Throwable e) {
            this.logger.error((Object)"general Error", e);
        }
        finally {
            if (pool != null && con != null) {
                pool.releaseConnection(con);
            }
        }
        return rs;
    }
}

