package org.gcube.data.spd.ncbi.capabilities;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.data.spd.ncbi.Database;
import org.gcube.data.spd.ncbi.NcbiPlugin;
import org.gcube.data.spd.ncbi.Utils;
import org.gcube.data.spd.plugin.fwk.Properties;
import org.gcube.data.spd.plugin.fwk.Property;
import org.gcube.data.spd.plugin.fwk.capabilities.ClassificationCapability;
import org.gcube.data.spd.plugin.fwk.exceptions.MethodNotSupportedException;
import org.gcube.data.spd.plugin.fwk.model.TaxonomyItem;
import org.gcube.data.spd.plugin.fwk.model.TaxonomyStatus;
import org.gcube.data.spd.plugin.fwk.writers.ObjectWriter;




public class ClassificationCapabilityImpl extends ClassificationCapability {

	GCUBELog logger = new GCUBELog(ClassificationCapabilityImpl.class);

	@Override
	public Set<Properties> getSupportedProperties() {
		return Collections.emptySet();
	}



	@Override
	public void getSynonymnsByIds(ObjectWriter<TaxonomyItem> writer,
			String... ids) throws MethodNotSupportedException {
		logger.trace("getSynonimnsByIds in NCBI...");
		ResultSet rs = null;

		for (String id: ids){

			Database database = null;  
			try {
				database = new Database();  			
				database.connect();
				//				logger.trace("select b.name_txt, a.rank, a.parent_tax_id from nodes as a NATURAL JOIN names as b where b.name_class = 'synonym' and a.tax_id = " + id  );
				rs = database.get("select a.tax_id, b.name_txt, a.rank, a.parent_tax_id, b.name_class from nodes as a NATURAL JOIN names as b where b.name_class = 'synonym' and a.tax_id = " + id  );
				while(rs.next()) {					
					TaxonomyItem item = createTaxonomyItem(rs);
					writer.put(item);
				}
			}			
			catch (SQLException sqlExcept) {
				logger.error("sql Error", sqlExcept);
			}catch (Throwable e) {
				logger.error("general Error", e);
			} finally {
				writer.close();
				try {										
					if (rs != null) 
						rs.close();
					try {
						database.shutDown();
					} catch (Exception e) {
						logger.error("General Error", e);
					}

				} catch (SQLException ex) {
					logger.error("sql Error", ex);
				}
			}
		}
		logger.trace("getSynonimnsByIds finished in NCBI");
	}



	private TaxonomyItem createTaxonomyItem(ResultSet rs) throws SQLException {

		String id = rs.getString(1);
		String ScName = rs.getString(2);
		//		logger.trace(ScName);
		String rank = rs.getString(3);
		String idParent = rs.getString(4);
		String status = rs.getString(5);

		TaxonomyItem item = new TaxonomyItem(id);
		item.setScientificName(ScName);
		item.setCommonNames(Utils.getCommonNames(Integer.parseInt(id)));
		item.setStatus(setTaxonomicStatus(status));
		item.setCredits(NcbiPlugin.credits);
		if (!rank.equals("no rank"))				
			item.setRank(rank);

		item.setAuthor(Utils.getCitation(Integer.parseInt(id)));

		if (!(idParent.equals("1")) && !(rank.equals("kingdom")))	
					
			item.setParent(createTaxItemById(Integer.parseInt(idParent)));

		return item;	     
	}



	@Override
	public List<TaxonomyItem> retrieveTaxonChildsByTaxonId(String id) {
		logger.trace("retrieveTaxonChildsByTaxonId " + id);
		List<TaxonomyItem> list = new ArrayList<TaxonomyItem>(); 		
		ResultSet rs = null;
		Database database = null;  
		try {
			database = new Database();  			
			database.connect();
			logger.trace("select  a.tax_id, b.name_txt, a.rank, a.parent_tax_id, b.name_class from nodes as a NATURAL JOIN names as b where a.parent_tax_id = " + id);
			rs = database.get("select a.tax_id, b.name_txt, a.rank, a.parent_tax_id, b.name_class from nodes as a NATURAL JOIN names as b where a.parent_tax_id = " + id);

			while(rs.next()){	
				TaxonomyItem tax = createTaxonomyItem(rs);
				list.add(tax); 
			}

		}
		catch (SQLException sqlExcept){        	
			logger.error("sql Error", sqlExcept);
		}
		catch (Throwable e){
			logger.error("general Error", e);
		} finally {

			try {

				if (rs != null) 
					rs.close();

				database.shutDown();
				//				logger.trace("close conn");

			} catch (SQLException ex) {
				logger.error("sql Error", ex);

			} catch (Exception e) {
				logger.error("General Error", e);
			}
		}

		return list;
	}




	@Override
	public void searchByCommonName(String name,
			ObjectWriter<TaxonomyItem> writer, Property... arg2) {
		logger.trace("Retrive Taxa By Common Name " + name);

		ResultSet rs = null;
		Database database = null;  

		try {
			database = new Database();  			
			database.connect();
//			logger.trace("select distinct(tax_id) from names where name_class = 'common name' and UPPER(name_txt) like UPPER('%" + name + "%')");
			rs = database.get("select distinct(tax_id) from names where name_class = 'common name' and UPPER(name_txt) like UPPER('%" + name + "%')");

			while(rs.next()) {	     
				int id = rs.getInt(1);
				TaxonomyItem item = createTaxItemById(id);
				writer.put(item);				
			}
		}
		catch (SQLException sqlExcept) {        	
			logger.error("sql Error", sqlExcept);
		}
		catch (Throwable e) {
			logger.error("general Error", e);
		} finally {
			writer.close();			
			try {
				if (rs != null) 
					rs.close();
				database.shutDown();
			} catch (SQLException ex) {
				logger.error("sql Error", ex);
			}
		}
	}



	@Override
	public void searchByScientificName(String name,
			ObjectWriter<TaxonomyItem> writer, Property... arg2) {

		logger.trace("Retrive Taxa By Scientific Name " + name);
		ResultSet rs = null ;

		Database database = null;  
		try {
			database = new Database();  			
			database.connect();
			//			logger.trace("select distinct(tax_id) from names where name_class = 'scientific name' and UPPER(name_txt) like UPPER('%" + name + "%')");
			rs = database.get("select distinct(tax_id) from names where name_class = 'scientific name' and UPPER(name_txt) like UPPER('%" + name + "%')");

			while(rs.next()) {	
				int id = rs.getInt(1);
				TaxonomyItem item = createTaxItemById(id);
				writer.put(item);
			}
		}

		catch (SQLException sqlExcept) {        	
			logger.error("sql Error", sqlExcept);
		}
		catch (Throwable e) {
			logger.error("general Error", e);
		} finally {
			writer.close();	
			try {
				if (rs != null) 
					rs.close();

				database.shutDown();

			} catch (SQLException ex) {
				logger.error("sql Error", ex);
			}
		}
	}



	private TaxonomyItem createTaxItemById(int id) {

		ResultSet rs = null ;
		TaxonomyItem item = null;
		Database database = null;  

		try {
			database = new Database();  			
			database.connect();

			rs = database.get("select a.tax_id, b.name_txt, a.rank, a.parent_tax_id, b.name_class from nodes as a NATURAL JOIN names as b where b.name_class = 'scientific name' and a.tax_id =" + id );

			if(rs.next()) {
				item = createTaxonomyItem(rs);				
			}		
		}
		catch (SQLException sqlExcept) {        	
			logger.error("sql Error", sqlExcept);
		}
		catch (Throwable e) {
			logger.error("general Error", e);
		} finally {

			try {
				if (rs != null) 
					rs.close();

				database.shutDown();

			} catch (SQLException ex) {
				logger.error("sql Error", ex);
			}
		}
		return item;
	}



	@Override
	public void retrieveTaxonByIds(Iterator<String> ids, ObjectWriter<TaxonomyItem> writer) {

		try {
			String id;
			while(ids.hasNext()) {

				id = ids.next(); 
				logger.trace("Retrive taxon by id " + id);
				TaxonomyItem item = createTaxItemById(Integer.parseInt(id));
				writer.put(item);
			}
		}
		catch (Throwable e) {
			logger.error("general Error", e);
		} finally {
			writer.close();	
			
		}

	}

	private TaxonomyStatus setTaxonomicStatus(String status) {
		TaxonomyStatus tax;
		if (status.equals("scientific name"))
			tax= new TaxonomyStatus(TaxonomyStatus.Status.ACCEPTED, status);
		else
			tax= new TaxonomyStatus(TaxonomyStatus.Status.UNKNOWN, status);
		return tax;
	}




}
