/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.spd.ncbi;

import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.data.spd.ncbi.NcbiPlugin;
import org.postgresql.copy.CopyManager;
import org.postgresql.core.BaseConnection;

public class Database {
    static GCUBELog logger = new GCUBELog(Database.class);
    private Connection connection;
    private String user;
    private String password;
    private String jdbc = NcbiPlugin.jdbc;
    private Statement statement;
    private final String driver = "org.postgresql.Driver";

    public Database() {
        this.user = NcbiPlugin.username;
        this.password = NcbiPlugin.password;
    }

    public boolean connect() {
        try {
            Class.forName("org.postgresql.Driver").newInstance();
            this.connection = DriverManager.getConnection(this.jdbc, this.user, this.password);
            return true;
        }
        catch (Exception ex) {
            logger.error((Object)"SQL Error", (Throwable)ex);
            return false;
        }
    }

    public ResultSet get(String query) {
        try {
            this.statement = this.connection.createStatement();
            ResultSet rs = this.statement.executeQuery(query);
            return rs;
        }
        catch (SQLException sqle) {
            return null;
        }
    }

    public boolean update(String query) {
        try {
            this.statement = this.connection.createStatement();
            this.statement.execute(query);
            return true;
        }
        catch (SQLException sqle) {
            return false;
        }
    }

    public boolean preStatement(String query, ArrayList<String> terms) {
        PreparedStatement stmt = null;
        try {
            stmt = this.connection.prepareStatement(query);
            for (int i = 0; i < terms.size(); ++i) {
                stmt.setString(i + 1, terms.get(i));
            }
            stmt.executeUpdate();
            return true;
        }
        catch (SQLException sqle) {
            logger.trace((Object)stmt);
            return false;
        }
    }

    public boolean shutDown() {
        try {
            this.connection.close();
            return true;
        }
        catch (SQLException sqlex) {
            return false;
        }
    }

    public boolean copy(String query, String file) {
        try {
            CopyManager copyManager = new CopyManager((BaseConnection)this.connection);
            FileReader fileReader = new FileReader(file);
            copyManager.copyIn(query, (Reader)fileReader);
            return true;
        }
        catch (SQLException e) {
            return false;
        }
        catch (IOException e) {
            return false;
        }
    }
}

