/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.spd.irmng.dbconnection;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Vector;
import org.gcube.data.spd.irmng.IrmngPlugin;
import org.gcube.data.spd.irmng.dbconnection.ConnectionPoolException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionPool {
    static Logger logger = LoggerFactory.getLogger(ConnectionPool.class);
    private static ConnectionPool connectionPool = null;
    private Vector<Connection> freeConnections = new Vector();
    private String dbUrl;
    private String dbDriver;
    private String dbLogin;
    private String dbPassword;

    private ConnectionPool() throws ConnectionPoolException {
        this.loadParameters();
        this.loadDriver();
    }

    private void loadParameters() {
        this.dbUrl = IrmngPlugin.jdbc;
        this.dbDriver = "org.postgresql.Driver";
        this.dbLogin = IrmngPlugin.user;
        this.dbPassword = IrmngPlugin.password;
    }

    private void loadDriver() throws ConnectionPoolException {
        try {
            Class.forName(this.dbDriver).newInstance();
        }
        catch (Exception e) {
            throw new ConnectionPoolException();
        }
    }

    public static synchronized ConnectionPool getConnectionPool() throws ConnectionPoolException {
        if (connectionPool == null) {
            connectionPool = new ConnectionPool();
        }
        return connectionPool;
    }

    public synchronized Connection getConnection() throws ConnectionPoolException, SQLException {
        Connection con = null;
        if (this.freeConnections.size() > 0) {
            con = this.freeConnections.firstElement();
            this.freeConnections.removeElementAt(0);
            try {
                if (con.isClosed()) {
                    con = this.getConnection();
                }
            }
            catch (SQLException e) {
                con = this.getConnection();
            }
        } else if (this.freeConnections.size() < 100) {
            con = this.newConnection();
        }
        return con;
    }

    private Connection newConnection() throws ConnectionPoolException {
        Connection con = null;
        try {
            con = DriverManager.getConnection(this.dbUrl, this.dbLogin, this.dbPassword);
        }
        catch (SQLException e) {
            throw new ConnectionPoolException();
        }
        return con;
    }

    public synchronized void releaseConnection(Connection con) {
        this.freeConnections.add(con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean preStatement(String query, ArrayList<String> terms, PreparedStatement stmt) {
        Connection con = null;
        try {
            con = this.getConnection();
            stmt = con.prepareStatement(query);
            for (int i = 0; i < terms.size(); ++i) {
                stmt.setString(i + 1, terms.get(i));
            }
            stmt.executeUpdate();
            stmt.clearParameters();
        }
        catch (SQLException sqle) {
            logger.trace("Error executing: " + stmt);
            boolean bl = false;
            return bl;
        }
        catch (ConnectionPoolException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (con != null) {
                this.releaseConnection(con);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean insertPreStatement(String query) {
        PreparedStatement stmt = null;
        Connection con = null;
        try {
            con = this.getConnection();
            stmt = con.prepareStatement(query);
            stmt.executeUpdate();
            boolean bl = true;
            return bl;
        }
        catch (SQLException sqle) {
            logger.trace("Error executing: " + stmt);
            boolean bl = false;
            return bl;
        }
        catch (ConnectionPoolException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (con != null) {
                this.releaseConnection(con);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet selectPrestatement(String query, String term) {
        PreparedStatement stmt = null;
        ResultSet result = null;
        Connection con = null;
        try {
            con = this.getConnection();
            stmt = con.prepareStatement(query);
            stmt.setString(1, term);
            result = stmt.executeQuery();
        }
        catch (SQLException e) {
            logger.error("SQLException", (Throwable)e);
        }
        catch (ConnectionPoolException e) {
            logger.error("ConnectionPoolException", (Throwable)e);
        }
        finally {
            if (con != null) {
                this.releaseConnection(con);
            }
        }
        return result;
    }
}

