/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.spd.irmng;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import org.gbif.dwc.terms.ConceptTerm;
import org.gbif.dwc.terms.DcTerm;
import org.gbif.dwc.terms.DwcTerm;
import org.gbif.dwc.text.Archive;
import org.gbif.dwc.text.ArchiveFactory;
import org.gbif.dwc.text.StarRecord;
import org.gbif.dwc.text.UnsupportedArchiveException;
import org.gbif.utils.file.ClosableIterator;
import org.gcube.data.spd.irmng.IrmngPlugin;
import org.gcube.data.spd.irmng.dbconnection.ConnectionPool;
import org.gcube.data.spd.irmng.dbconnection.ConnectionPoolException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class UpdateThread
extends Thread {
    long nextup;
    static Logger logger = LoggerFactory.getLogger(UpdateThread.class);

    UpdateThread(long update) {
        super("Thread");
        this.start();
        this.nextup = update;
    }

    @Override
    public void run() {
        java.util.Date date = new java.util.Date();
        logger.trace("Irmng DB will be updated on " + this.nextUpdateDate(this.nextup + date.getTime()));
        while (true) {
            try {
                while (true) {
                    UpdateThread.sleep(this.nextup);
                    this.update();
                    this.setlastupdate();
                    this.nextup = 2592000000L;
                }
            }
            catch (InterruptedException e) {
                logger.error("InterruptedException", (Throwable)e);
                continue;
            }
            break;
        }
    }

    private String nextUpdateDate(long input) {
        java.util.Date date = new java.util.Date(input);
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        return dateFormat.format(date);
    }

    /*
     * Loose catch block
     */
    protected void update() {
        File tempFolder = null;
        try {
            URL url = new URL(IrmngPlugin.dumpUrl);
            tempFolder = File.createTempFile("irmng-folder", "");
            tempFolder.delete();
            tempFolder.mkdir();
            if (this.downloadFromUrl(url, tempFolder + "/IRMNG_DWC.zip")) {
                this.openArch(tempFolder);
            }
            if (tempFolder != null) {
                this.clearTmp(tempFolder);
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            if (tempFolder != null) {
                this.clearTmp(tempFolder);
            }
        }
        catch (IOException e2) {
            e2.printStackTrace();
            if (tempFolder != null) {
                this.clearTmp(tempFolder);
            }
            {
                catch (Throwable throwable) {
                    if (tempFolder != null) {
                        this.clearTmp(tempFolder);
                    }
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setlastupdate() {
        ConnectionPool pool = null;
        Connection con = null;
        try {
            pool = ConnectionPool.getConnectionPool();
            con = pool.getConnection();
            java.util.Date date = new java.util.Date();
            long dt = date.getTime();
            Date today = new Date(dt);
            String query = "insert into updates (date) values ('" + today + "')";
            boolean result = pool.insertPreStatement(query);
            if (!result) {
                logger.trace("problem setting last update date");
            }
        }
        catch (ConnectionPoolException e) {
            logger.error("ConnectionPoolException", (Throwable)e);
        }
        catch (SQLException e) {
            logger.error("SQLException", (Throwable)e);
        }
        finally {
            if (pool != null && con != null) {
                pool.releaseConnection(con);
            }
        }
    }

    private void clearTmp(File f) {
        if (f.exists()) {
            for (File c : f.listFiles()) {
                if (c.isDirectory()) {
                    this.clearTmp(c);
                }
                c.delete();
            }
            f.delete();
        }
        logger.trace("Deleted files");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean downloadFromUrl(URL url, String string) throws IOException {
        boolean flag = false;
        logger.trace("Downloading " + string);
        InputStream is = null;
        FileOutputStream fos = null;
        try {
            int len;
            URLConnection urlConn = url.openConnection();
            is = urlConn.getInputStream();
            fos = new FileOutputStream(string);
            byte[] buffer = new byte[4096];
            while ((len = is.read(buffer)) > 0) {
                fos.write(buffer, 0, len);
            }
            flag = true;
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            finally {
                if (fos != null) {
                    fos.close();
                }
            }
        }
        return flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void openArch(File tempFolder) {
        block14: {
            try {
                Archive arch = ArchiveFactory.openArchive((File)new File(tempFolder + "/IRMNG_DWC.zip"), (File)tempFolder);
                if (!arch.getCore().hasTerm((ConceptTerm)DwcTerm.scientificName)) {
                    logger.trace("This application requires dwc-a with scientific names");
                    break block14;
                }
                ConnectionPool pool = null;
                Connection con = null;
                ResultSet result = null;
                try {
                    pool = ConnectionPool.getConnectionPool();
                    con = pool.getConnection();
                    ClosableIterator iter = arch.iterator();
                    String stmt = null;
                    ArrayList<String> terms = new ArrayList<String>();
                    PreparedStatement stmtInsert = null;
                    while (iter.hasNext()) {
                        StarRecord dwc = (StarRecord)iter.next();
                        logger.trace(dwc.core().id());
                        terms.add(dwc.core().id());
                        terms.add(dwc.core().value((ConceptTerm)DwcTerm.scientificName));
                        terms.add(dwc.core().value((ConceptTerm)DwcTerm.scientificNameAuthorship));
                        terms.add(dwc.core().value((ConceptTerm)DwcTerm.genus));
                        terms.add(dwc.core().value((ConceptTerm)DwcTerm.specificEpithet));
                        terms.add(dwc.core().value((ConceptTerm)DwcTerm.family));
                        terms.add(dwc.core().value((ConceptTerm)DwcTerm.taxonRank));
                        terms.add(dwc.core().value((ConceptTerm)DwcTerm.taxonomicStatus));
                        terms.add(dwc.core().value((ConceptTerm)DwcTerm.nomenclaturalStatus));
                        terms.add(dwc.core().value((ConceptTerm)DwcTerm.nameAccordingTo));
                        terms.add(dwc.core().value((ConceptTerm)DwcTerm.originalNameUsageID));
                        terms.add(dwc.core().value((ConceptTerm)DwcTerm.namePublishedIn));
                        terms.add(dwc.core().value((ConceptTerm)DwcTerm.acceptedNameUsageID));
                        terms.add(dwc.core().value((ConceptTerm)DwcTerm.parentNameUsage));
                        terms.add(dwc.core().value((ConceptTerm)DwcTerm.parentNameUsageID));
                        terms.add(dwc.core().value((ConceptTerm)DwcTerm.taxonRemarks));
                        terms.add(dwc.core().value((ConceptTerm)DcTerm.modified));
                        terms.add(dwc.core().value((ConceptTerm)DwcTerm.nomenclaturalCode));
                        String query = "select count(*) from taxon where taxonid = ?";
                        result = pool.selectPrestatement(query, dwc.core().id());
                        if (!result.next()) continue;
                        stmt = result.getInt(1) == 0 ? "insert into taxon (taxonid, scientificname, scientificnameauthorship, genus, specificepithet, family, taxonrank, taxonomicstatus, nomenclaturalstatus, nameaccordingto, originalnameusageid, namepublishedin, acceptednameusageid, parentnameusage, parentnameusageid, taxonremarks, modified, nomenclaturalcode) values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)" : "update taxon set taxonid = ?, scientificname = ?, scientificnameauthorship = ?, genus = ?, specificepithet = ?, family = ?, taxonrank = ?, taxonomicstatus = ?, nomenclaturalstatus = ?, nameaccordingto = ?, originalnameusageid = ?, namepublishedin = ?, acceptednameusageid = ?, parentnameusage = ?, parentnameusageid = ?, taxonremarks = ?, modified = ?, nomenclaturalcode = ? where taxonid ='" + dwc.core().id() + "'";
                        if (!pool.preStatement(stmt, terms, stmtInsert)) {
                            logger.trace("error");
                        }
                        terms.clear();
                    }
                }
                catch (ConnectionPoolException e) {
                    logger.error("ConnectionPoolException", (Throwable)e);
                }
                finally {
                    logger.trace("completed!");
                    if (result != null) {
                        result.close();
                    }
                    if (pool != null && con != null) {
                        pool.releaseConnection(con);
                    }
                }
            }
            catch (UnsupportedArchiveException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long lastupdate() {
        ConnectionPool pool = null;
        Connection con = null;
        ResultSet results = null;
        long nextUpdate = 0L;
        try {
            pool = ConnectionPool.getConnectionPool();
            con = pool.getConnection();
            Statement statement = con.createStatement();
            String query = "select date from updates where id= (select max(id) from updates)";
            results = statement.executeQuery(query);
            Date lastUpdate = null;
            if (results.next()) {
                lastUpdate = results.getDate(1);
                java.util.Date date = new java.util.Date();
                long days = date.getTime() - lastUpdate.getTime();
                if (days < 2592000000L) {
                    long l = 2592000000L - days;
                    return l;
                }
            }
        }
        catch (SQLException e) {
            logger.error("SQLException", (Throwable)e);
        }
        catch (ConnectionPoolException e) {
            logger.error("ConnectionPoolException", (Throwable)e);
        }
        finally {
            if (pool != null && con != null) {
                pool.releaseConnection(con);
            }
            try {
                if (results != null) {
                    results.close();
                }
            }
            catch (SQLException ex) {
                logger.error("sql Error", (Throwable)ex);
            }
        }
        return nextUpdate;
    }
}

