/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.spd.irmng;

import java.util.Date;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class DateUtil {
    protected static final String[] DATE_FORMATS = new String[]{"yyyy-MM-dd'T'HH:mm:ss.SSSZZ", "yyyy-MM-dd'T'HH:mm:ss:mm:ssZ", "yyyy-MM-dd' 'HH:mm:ss.SSSSSS", "yyyy-MM-dd'T'HH:mm:ssZZ", "yyyy-MM-dd'T'HH:mm:sssZZ", "yyyy-MM-dd' 'HH:mm:ssZZ", "yyyy-MM-dd'T'HH:mm:ssz", "yyyy-MM-dd' 'HH:mm:ss", "yyyy-MM-dd'T'HH:mmZ", "dd/MM/yyyyHH:mm:ssZ", "yyyy-MM-dd' 'HH:mm", "yyyy-MM-dd'T'", "yyyy-MM-dd-'T'", "yyyy-MM-dd", "yyyy", "MM-yyyy", "MMM-yyyy", "dd-MMM-yy", "dd/MM/yyyy", "dd-MM-yyyy", "MM/dd/yyyy' 'HH:mm:ss", "MM/dd/yyyy", "yyyy/MM/dd' 'HH:mm:ss"};
    protected static DateUtil instance;
    protected DateTimeFormatter[] FORMATS = new DateTimeFormatter[DATE_FORMATS.length];

    public static DateUtil getInstance() {
        if (instance == null) {
            instance = new DateUtil();
            instance.initialize();
        }
        return instance;
    }

    protected DateUtil() {
    }

    protected void initialize() {
        int i = 0;
        String[] stringArray = DATE_FORMATS;
        int n = DATE_FORMATS.length;
        int n2 = 0;
        while (n2 < n) {
            String dateFormat = stringArray[n2];
            this.FORMATS[i++] = DateTimeFormat.forPattern((String)dateFormat);
            ++n2;
        }
    }

    public Date parse(String dateString) {
        DateTimeFormatter[] dateTimeFormatterArray = this.FORMATS;
        int n = this.FORMATS.length;
        int n2 = 0;
        while (n2 < n) {
            DateTimeFormatter formatter = dateTimeFormatterArray[n2];
            try {
                return formatter.parseDateTime(dateString).toDate();
            }
            catch (Exception exception) {
                ++n2;
            }
        }
        return null;
    }
}

