/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.spd.irmng;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.data.spd.irmng.Database;
import org.gcube.data.spd.irmng.Utils;
import org.gcube.data.spd.plugin.fwk.Properties;
import org.gcube.data.spd.plugin.fwk.Property;
import org.gcube.data.spd.plugin.fwk.capabilities.ClassificationCapability;
import org.gcube.data.spd.plugin.fwk.exceptions.MethodNotSupportedException;
import org.gcube.data.spd.plugin.fwk.model.TaxonomyItem;
import org.gcube.data.spd.plugin.fwk.model.TaxonomyStatus;
import org.gcube.data.spd.plugin.fwk.writers.ObjectWriter;

public class ClassificationCapabilityImpl
extends ClassificationCapability {
    GCUBELog logger = new GCUBELog(ClassificationCapabilityImpl.class);

    public Set<Properties> getSupportedProperties() {
        return Collections.emptySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TaxonomyItem> retrieveTaxonChildsByTaxonId(String id_parent) {
        ArrayList<TaxonomyItem> list = new ArrayList<TaxonomyItem>();
        this.logger.trace((Object)("retrieveTaxonChildsByTaxonId " + id_parent));
        ResultSet results = null;
        Database database = null;
        try {
            database = new Database();
            database.connect();
            this.logger.trace((Object)("select taxonid, taxonrank, scientificnameauthorship, taxonomicstatus, modified, acceptednameusageid, parentnameusageid from taxon where parentnameusageid = '" + id_parent + "'"));
            results = database.get("select taxonid, taxonrank, scientificnameauthorship, taxonomicstatus, modified, acceptednameusageid, parentnameusageid from taxon where parentnameusageid = '" + id_parent + "'");
            while (results.next()) {
                TaxonomyItem item = this.createTaxonomyItem(results);
                list.add(item);
            }
        }
        catch (SQLException sqlExcept) {
            this.logger.error((Object)"sql Error", (Throwable)sqlExcept);
        }
        catch (Throwable e) {
            this.logger.error((Object)"general Error", e);
        }
        finally {
            try {
                results.close();
            }
            catch (SQLException e) {
                this.logger.error((Object)"SQLException", (Throwable)e);
            }
            database.shutDown();
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TaxonomyItem createTaxonomyItemById(String id) {
        TaxonomyItem item = null;
        ResultSet results = null;
        Database database = null;
        try {
            database = new Database();
            database.connect();
            results = database.get("select taxonid, taxonrank, scientificnameauthorship, taxonomicstatus, modified, acceptednameusageid, parentnameusageid from taxon where taxonid = '" + id + "'");
            if (results.next()) {
                item = this.createTaxonomyItem(results);
            } else {
                this.logger.trace((Object)("id " + id + " not in IRMNG"));
            }
        }
        catch (SQLException sqlExcept) {
            this.logger.error((Object)"sql Error", (Throwable)sqlExcept);
        }
        finally {
            try {
                if (results != null) {
                    results.close();
                }
            }
            catch (SQLException e) {
                this.logger.error((Object)"sql Error", (Throwable)e);
            }
            database.shutDown();
        }
        return item;
    }

    private TaxonomyStatus setTaxStatus(String status, String syn_parent) {
        TaxonomyStatus tax = null;
        tax = status != null ? (status.equals("accepted") ? new TaxonomyStatus("accepted", TaxonomyStatus.Status.ACCEPTED) : (status.equals("valid") ? new TaxonomyStatus("valid", TaxonomyStatus.Status.VALID) : (status.equals("synonym") ? new TaxonomyStatus(TaxonomyStatus.Status.SYNONYM, syn_parent, "synonym") : new TaxonomyStatus(status, TaxonomyStatus.Status.UNKNOWN)))) : new TaxonomyStatus(status, TaxonomyStatus.Status.UNKNOWN);
        return tax;
    }

    public void searchByCommonName(String name, ObjectWriter<TaxonomyItem> writer, Property ... arg2) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void searchByScientificName(String scientificName, ObjectWriter<TaxonomyItem> writer, Property ... arg2) {
        this.logger.trace((Object)("searchByScientificName " + scientificName));
        ResultSet results = null;
        Database database = null;
        try {
            database = new Database();
            database.connect();
            results = database.get("select taxonid, taxonrank, scientificnameauthorship, taxonomicstatus, modified, acceptednameusageid, parentnameusageid from taxon where UPPER(scientificname) like UPPER('%" + scientificName + "%')");
            while (results.next()) {
                TaxonomyItem item = this.createTaxonomyItem(results);
                writer.put((Object)item);
            }
        }
        catch (SQLException sqlExcept) {
            this.logger.error((Object)"sql Error", (Throwable)sqlExcept);
        }
        finally {
            if (results != null) {
                try {
                    results.close();
                }
                catch (SQLException e) {
                    this.logger.error((Object)"sql Error", (Throwable)e);
                }
            }
            database.shutDown();
            writer.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void retrieveTaxonByIds(Iterator<String> ids, ObjectWriter<TaxonomyItem> writer) {
        try {
            while (ids.hasNext()) {
                String id = ids.next();
                this.logger.trace((Object)("retrieveTaxonById " + id));
                TaxonomyItem item = this.createTaxonomyItemById(id);
                writer.put((Object)item);
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"ExceptionPrintStackTrace", (Throwable)e);
        }
        finally {
            writer.close();
        }
    }

    private TaxonomyItem createTaxonomyItem(ResultSet result) throws SQLException {
        String id = result.getString(1);
        String rank = result.getString(2);
        String citation = result.getString(3);
        String status = result.getString(4);
        Calendar modified = Utils.getCalendar(result.getString(5));
        String syn_parent = result.getString(6);
        String id_parent = result.getString(7);
        TaxonomyItem item = new TaxonomyItem(id);
        item.setScientificName(Utils.setScName(id, rank));
        item.setCitation(citation);
        item.setRank(rank);
        item.setStatus(this.setTaxStatus(status, syn_parent));
        item.setModified(modified);
        if (id_parent != null) {
            item.setParent(this.createTaxonomyItemById(id_parent));
        } else {
            item.setParent(null);
        }
        return item;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getSynonymnsByIds(ObjectWriter<TaxonomyItem> writer, String ... ids) throws MethodNotSupportedException {
        try {
            for (int i = 0; i < ids.length; ++i) {
                Iterator<String> iterator = this.getSynonimnsById(ids[i]);
                this.retrieveTaxonByIds(iterator, writer);
            }
        }
        finally {
            writer.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Iterator<String> getSynonimnsById(String id) {
        this.logger.trace((Object)("getSynonimnsById " + id));
        ResultSet results = null;
        Database database = null;
        ArrayList<String> ids = new ArrayList<String>();
        Iterator i = null;
        try {
            database = new Database();
            database.connect();
            this.logger.trace((Object)("select distinct(taxonid) from taxon where taxonomicstatus = 'synonym' and acceptednameusageid = '" + id + "'"));
            results = database.get("select distinct(taxonid) from taxon where taxonomicstatus = 'synonym' and acceptednameusageid = '" + id + "'");
            while (results.next()) {
                ids.add(results.getString(1));
            }
            i = ids.iterator();
        }
        catch (Throwable e) {
            this.logger.error((Object)"general Error", e);
        }
        finally {
            database.shutDown();
        }
        return i;
    }
}

