/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.spd.irmng;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Set;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.data.spd.irmng.Database;
import org.gcube.data.spd.irmng.Utils;
import org.gcube.data.spd.plugin.fwk.Properties;
import org.gcube.data.spd.plugin.fwk.capabilities.SynonimsCapability;
import org.gcube.data.spd.plugin.fwk.model.DataProvider;
import org.gcube.data.spd.plugin.fwk.model.DataSet;
import org.gcube.data.spd.plugin.fwk.model.ResultItem;
import org.gcube.data.spd.plugin.fwk.writers.ObjectWriter;

public class SynonimsCapabilityImpl
implements SynonimsCapability {
    GCUBELog logger = new GCUBELog(SynonimsCapabilityImpl.class);

    public Set<Properties> getSupportedProperties() {
        return Collections.emptySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getSynonimnsByIds(ObjectWriter<ResultItem> writer, String ... ids) {
        ResultSet results = null;
        try {
            for (int i = 0; i < ids.length; ++i) {
                results = this.getSynonimnsById(ids[i]);
                try {
                    while (results.next()) {
                        this.createRIById(results.getString(1), writer);
                    }
                    continue;
                }
                catch (SQLException e) {
                    this.logger.error((Object)"sql Error", (Throwable)e);
                    continue;
                }
                finally {
                    try {
                        results.close();
                    }
                    catch (SQLException e) {
                        this.logger.error((Object)"SQLException", (Throwable)e);
                    }
                }
            }
        }
        finally {
            writer.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResultSet getSynonimnsById(String id) {
        this.logger.trace((Object)("getSynonimnsById " + id));
        ResultSet results = null;
        Database database = null;
        try {
            database = new Database();
            database.connect();
            this.logger.trace((Object)("select distinct(taxonid) from taxon where taxonomicstatus = 'synonym' and acceptednameusageid = '" + id + "'"));
            results = database.get("select distinct(taxonid) from taxon where taxonomicstatus = 'synonym' and acceptednameusageid = '" + id + "'");
        }
        catch (Throwable e) {
            this.logger.error((Object)"general Error", e);
        }
        finally {
            database.shutDown();
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createRIById(String id, ObjectWriter<ResultItem> writer) {
        this.logger.trace((Object)("createRIById " + id));
        ResultSet results = null;
        Database database = null;
        String ScName = "";
        String rank = "";
        String idParent = "";
        String citation = "";
        try {
            database = new Database();
            database.connect();
            results = database.get("select scientificname, taxonrank, parentnameusageid, scientificnameauthorship from taxon where acceptednameusageid = '" + id + "'");
            while (results.next()) {
                ScName = results.getString(1);
                rank = results.getString(2);
                idParent = results.getString(3);
                citation = results.getString(4);
                ResultItem item = new ResultItem(id, ScName);
                item.setCitation(citation);
                item.setCredits("IRMNG - Digital resource at http://www.obis.org.au/irmng/.");
                item.setRank(rank);
                DataSet dataSet = new DataSet("irmngid");
                dataSet.setName("IRMNG");
                DataProvider dp = new DataProvider("irmngid");
                dp.setName("IRMNG");
                dataSet.setDataProvider(dp);
                item.setDataSet(dataSet);
                item.setParent(Utils.createTaxonomy(idParent));
                writer.put((Object)item);
            }
        }
        catch (SQLException sqlExcept) {
            this.logger.error((Object)"sql Error", (Throwable)sqlExcept);
        }
        catch (Throwable e) {
            this.logger.error((Object)"general Error", e);
        }
        finally {
            try {
                results.close();
            }
            catch (SQLException e) {
                this.logger.error((Object)"general Error", (Throwable)e);
            }
            database.shutDown();
        }
    }
}

