/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataaccess.spd.havingengine.exl;

import java.util.HashMap;
import org.apache.commons.jexl2.Expression;
import org.apache.commons.jexl2.JexlEngine;
import org.gcube.dataaccess.spd.havingengine.HavingStatement;
import org.gcube.dataaccess.spd.havingengine.HavingStatementFactory;
import org.gcube.dataaccess.spd.havingengine.exl.HavingContext;
import org.gcube.dataaccess.spd.havingengine.exl.HavingFunctions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HavingStatementFactoryEXL
implements HavingStatementFactory {
    protected Logger logger = LoggerFactory.getLogger(HavingStatementFactoryEXL.class);
    protected JexlEngine engine = new JexlEngine();

    public HavingStatementFactoryEXL() {
        HashMap<Object, Class<HavingFunctions>> functions = new HashMap<Object, Class<HavingFunctions>>();
        functions.put(null, HavingFunctions.class);
        this.engine.setFunctions(functions);
    }

    @Override
    public <T> HavingStatement<T> compile(String expression) throws Exception {
        this.logger.debug("compile {}", (Object)expression);
        Expression expr = this.engine.createExpression(expression);
        return new HavingStatementJEXL(this.engine, expr);
    }

    protected class HavingStatementJEXL<T>
    implements HavingStatement<T> {
        protected Logger logger = LoggerFactory.getLogger(HavingStatementJEXL.class);
        protected JexlEngine engine;
        protected Expression expression;

        private HavingStatementJEXL(JexlEngine engine, Expression expression) {
            this.engine = engine;
            this.expression = expression;
        }

        @Override
        public boolean accept(T element) {
            try {
                HavingContext<T> context = new HavingContext<T>(this.engine, element);
                return (Boolean)this.expression.evaluate(context);
            }
            catch (Exception e) {
                this.logger.debug("Error evaluating expression", (Throwable)e);
                return false;
            }
        }
    }
}

