/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.spd.gbifplugin.search.query;

import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import lombok.NonNull;
import org.gcube.data.spd.gbifplugin.search.query.QueryCondition;
import org.gcube.data.spd.gbifplugin.search.query.ResultType;

public class PagedQueryObject {
    @NonNull
    private String baseUri;
    List<QueryCondition> conditions = new ArrayList<QueryCondition>();
    @NonNull
    private ResultType resultType;
    @NonNull
    private Integer resultPerQuery;
    private int offset = 0;

    public void setConditions(QueryCondition ... conditions) {
        this.conditions = Arrays.asList(conditions);
    }

    public String buildNext() {
        StringBuilder query = new StringBuilder(this.baseUri);
        if (!this.baseUri.endsWith("/")) {
            query.append("/");
        }
        query.append(this.resultType.getQueryEntry()).append("/");
        query.append("search/?limit=").append(this.resultPerQuery);
        query.append("&offset=").append(this.offset);
        if (this.conditions.size() > 0) {
            for (QueryCondition queryCond : this.conditions) {
                query.append("&").append(queryCond.getKey()).append("=").append(queryCond.getValue());
            }
        }
        this.offset += this.resultPerQuery.intValue();
        return query.toString();
    }

    @ConstructorProperties(value={"baseUri", "resultType", "resultPerQuery"})
    public PagedQueryObject(@NonNull String baseUri, @NonNull ResultType resultType, @NonNull Integer resultPerQuery) {
        if (baseUri == null) {
            throw new NullPointerException("baseUri");
        }
        if (resultType == null) {
            throw new NullPointerException("resultType");
        }
        if (resultPerQuery == null) {
            throw new NullPointerException("resultPerQuery");
        }
        this.baseUri = baseUri;
        this.resultType = resultType;
        this.resultPerQuery = resultPerQuery;
    }

    public List<QueryCondition> getConditions() {
        return this.conditions;
    }
}

