/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.spd.asfis.capabilities;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.data.spd.asfis.Utils;
import org.gcube.data.spd.asfis.dbconnection.ConnectionPool;
import org.gcube.data.spd.model.Condition;
import org.gcube.data.spd.model.Conditions;
import org.gcube.data.spd.model.exceptions.ExternalRepositoryException;
import org.gcube.data.spd.model.exceptions.IdNotValidException;
import org.gcube.data.spd.model.exceptions.StreamBlockingException;
import org.gcube.data.spd.model.exceptions.StreamException;
import org.gcube.data.spd.model.products.TaxonomyItem;
import org.gcube.data.spd.model.products.TaxonomyStatus;
import org.gcube.data.spd.plugin.fwk.capabilities.ClassificationCapability;
import org.gcube.data.spd.plugin.fwk.writers.ClosableWriter;
import org.gcube.data.spd.plugin.fwk.writers.ObjectWriter;

public class ClassificationCapabilityImpl
extends ClassificationCapability {
    GCUBELog logger = new GCUBELog(ClassificationCapabilityImpl.class);

    public Set<Conditions> getSupportedProperties() {
        return Collections.emptySet();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void retrieveTaxonByIds(Iterator<String> ids, ClosableWriter<TaxonomyItem> writer) {
        try {
            try {
                while (true) {
                    if (!ids.hasNext()) {
                        return;
                    }
                    String id = ids.next();
                    TaxonomyItem item = null;
                    try {
                        item = this.retrieveTaxonById(id);
                        if (item == null) continue;
                        if (!writer.isAlive()) return;
                        if (item == null) return;
                        writer.write((Object)item);
                    }
                    catch (IdNotValidException e) {
                        this.logger.error((Object)"Id Not Valid", (Throwable)e);
                    }
                }
            }
            catch (Exception e) {
                writer.write((StreamException)new StreamBlockingException("ASFIS", ""));
                writer.close();
                return;
            }
        }
        finally {
            writer.close();
        }
    }

    public TaxonomyItem retrieveTaxonById(String id) throws IdNotValidException {
        TaxonomyItem tax;
        block13: {
            ConnectionPool pool = null;
            ResultSet results = null;
            tax = null;
            try {
                try {
                    pool = ConnectionPool.getConnectionPool();
                    String query = "select Scientific_name, Author, Family, Order_rank, English_name, French_name, Spanish_name from asfis where TAXOCODE = ?";
                    results = pool.selectPrestatement(query, id);
                    if (results.next()) {
                        String scientific_name = results.getString(1);
                        String author = results.getString(2);
                        String family = results.getString(3);
                        String order = results.getString(4);
                        String englishName = results.getString(5);
                        String frenchName = results.getString(6);
                        String spanishName = results.getString(7);
                        tax = this.createTaxonomyItem(id, scientific_name, author, family, order, englishName, frenchName, spanishName);
                    }
                }
                catch (Throwable e) {
                    this.logger.error((Object)"Id not valid exception", e);
                    if (results == null) break block13;
                    try {
                        results.close();
                    }
                    catch (SQLException e2) {
                        this.logger.error((Object)"general Error", (Throwable)e2);
                    }
                }
            }
            finally {
                if (results != null) {
                    try {
                        results.close();
                    }
                    catch (SQLException e) {
                        this.logger.error((Object)"general Error", (Throwable)e);
                    }
                }
            }
        }
        return tax;
    }

    public List<TaxonomyItem> retrieveTaxonChildrenByTaxonId(String idParent) throws IdNotValidException, ExternalRepositoryException {
        ArrayList<TaxonomyItem> list;
        block21: {
            this.logger.info((Object)("retrieveTaxonChildrenByTaxonId " + idParent));
            list = null;
            ResultSet results = null;
            Boolean kingdom = false;
            Boolean order = false;
            try {
                try {
                    if (idParent.equals("Animalia")) {
                        results = this.getOrders();
                        kingdom = true;
                        this.logger.info((Object)(String.valueOf(idParent) + " is kingdom"));
                    } else {
                        results = this.createResultItemChilds(idParent);
                    }
                    if (!results.next() && (results = this.getFamilies(idParent)).next()) {
                        order = true;
                        this.logger.info((Object)(String.valueOf(idParent) + " is order"));
                    }
                    list = new ArrayList<TaxonomyItem>();
                    do {
                        TaxonomyItem kingdomTaxon;
                        TaxonomyItem tax = null;
                        if (kingdom & !results.getString(1).equals(0)) {
                            tax = this.createBaseTaxItem(results.getString(1), "Order");
                            kingdomTaxon = this.createRankTaxItem("Animalia", "Animalia", null);
                            tax.setParent(kingdomTaxon);
                        } else if (order & !results.getString(1).equals("")) {
                            tax = this.createBaseTaxItem(results.getString(1), "Family");
                            kingdomTaxon = this.createRankTaxItem("Animalia", "Animalia", null);
                            TaxonomyItem familyTaxon = this.createRankTaxItem(idParent, "Family", kingdomTaxon);
                            tax.setParent(familyTaxon);
                        } else if (kingdom == false & order == false) {
                            String id = results.getString(1);
                            String scientific_name = results.getString(2);
                            String author = results.getString(3);
                            String family = results.getString(4);
                            String order_rank = results.getString(5);
                            String englishName = results.getString(6);
                            String frenchName = results.getString(7);
                            String spanishName = results.getString(8);
                            tax = this.createTaxonomyItem(id, scientific_name, author, family, order_rank, englishName, frenchName, spanishName);
                        }
                        if (tax == null) continue;
                        list.add(tax);
                    } while (results.next());
                }
                catch (SQLException e) {
                    this.logger.error((Object)"sql Error", (Throwable)e);
                    if (results == null) break block21;
                    try {
                        results.close();
                    }
                    catch (SQLException e2) {
                        this.logger.error((Object)"general Error", (Throwable)e2);
                    }
                }
            }
            finally {
                if (results != null) {
                    try {
                        results.close();
                    }
                    catch (SQLException e) {
                        this.logger.error((Object)"general Error", (Throwable)e);
                    }
                }
            }
        }
        return list;
    }

    private TaxonomyItem createBaseTaxItem(String result, String rank) {
        TaxonomyItem tax = new TaxonomyItem(result);
        tax.setScientificName(result);
        tax.setRank(rank);
        tax.setStatus(new TaxonomyStatus("Validated", TaxonomyStatus.Status.VALID));
        tax.setCitation(Utils.createCitation());
        tax.setCredits(Utils.createCredits());
        return tax;
    }

    private TaxonomyItem createTaxonomyItem(String id, String scientific_name, String author, String family, String order, String englishName, String frenchName, String spanishName) throws SQLException {
        TaxonomyItem item = null;
        try {
            item = new TaxonomyItem(id);
            item.setScientificName(scientific_name);
            item.setRank("Species");
            item.setAuthor(author);
            item.setStatus(new TaxonomyStatus("Validated", TaxonomyStatus.Status.VALID));
            item.setCommonNames(Utils.setCommonNames(englishName, frenchName, spanishName));
            item.setCitation(Utils.createCitation());
            item.setCredits(Utils.createCredits());
            TaxonomyItem kingdomTaxon = this.createRankTaxItem("Animalia", "Animalia", null);
            TaxonomyItem familyTaxon = this.createRankTaxItem(family, "Family", kingdomTaxon);
            TaxonomyItem orderTaxon = this.createRankTaxItem(order, "Order", familyTaxon);
            item.setParent(orderTaxon);
        }
        catch (Exception e) {
            this.logger.error((Object)"ID not valid Exception", (Throwable)e);
        }
        return item;
    }

    private TaxonomyItem createRankTaxItem(String name, String rank, TaxonomyItem parent) {
        TaxonomyItem rankTaxon = new TaxonomyItem(name);
        rankTaxon.setScientificName(name);
        rankTaxon.setRank(rank);
        rankTaxon.setParent(parent);
        return rankTaxon;
    }

    private ResultSet getOrders() {
        ConnectionPool pool = null;
        ResultSet results = null;
        try {
            pool = ConnectionPool.getConnectionPool();
            String query = "select distinct(order_rank) from asfis";
            results = pool.selectPrestatement(query, null);
        }
        catch (Throwable e) {
            this.logger.error((Object)"general Error", e);
        }
        return results;
    }

    private ResultSet getFamilies(String order) {
        ConnectionPool pool = null;
        ResultSet results = null;
        try {
            pool = ConnectionPool.getConnectionPool();
            String term = "%" + order + "%";
            String query = "select distinct(family) from asfis where UPPER(order_rank) like UPPER(?)";
            results = pool.selectPrestatement(query, term);
        }
        catch (Throwable e) {
            this.logger.error((Object)"general Error", e);
        }
        return results;
    }

    private ResultSet createResultItemChilds(String id) {
        ConnectionPool pool = null;
        ResultSet results = null;
        try {
            pool = ConnectionPool.getConnectionPool();
            String query = "select TAXOCODE, Scientific_name, Author, Family, Order_rank, English_name, French_name, Spanish_name from asfis where family = ?";
            results = pool.selectPrestatement(query, id);
        }
        catch (Throwable e) {
            this.logger.error((Object)"general Error", e);
        }
        return results;
    }

    public void searchByScientificName(String name, ObjectWriter<TaxonomyItem> writer, Condition ... properties) {
        block14: {
            this.logger.trace((Object)("Retrive taxa by name " + name));
            ResultSet results = null;
            try {
                try {
                    results = Utils.createResultSetByName(name);
                    if (results == null) break block14;
                    while (results.next()) {
                        String id = results.getString(1);
                        String scientific_name = results.getString(2);
                        String author = results.getString(3);
                        String family = results.getString(4);
                        String order = results.getString(5);
                        String englishName = results.getString(6);
                        String frenchName = results.getString(7);
                        String spanishName = results.getString(8);
                        TaxonomyItem tax = this.createTaxonomyItem(id, scientific_name, author, family, order, englishName, frenchName, spanishName);
                        if (writer.isAlive() && tax != null) {
                            writer.write((Object)tax);
                            continue;
                        }
                        break;
                    }
                }
                catch (Exception e) {
                    writer.write((StreamException)new StreamBlockingException("ASFIS", ""));
                    if (results == null) break block14;
                    try {
                        results.close();
                    }
                    catch (SQLException e2) {
                        this.logger.error((Object)"general Error", (Throwable)e2);
                    }
                }
            }
            finally {
                if (results != null) {
                    try {
                        results.close();
                    }
                    catch (SQLException e) {
                        this.logger.error((Object)"general Error", (Throwable)e);
                    }
                }
            }
        }
    }
}

