package org.gcube.data.spd.asfis;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Set;

import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.resources.gcore.ServiceEndpoint;
import org.gcube.common.resources.gcore.ServiceEndpoint.AccessPoint;
import org.gcube.common.utils.encryption.StringEncrypter;
import org.gcube.data.spd.asfis.capabilities.ClassificationCapabilityImpl;
import org.gcube.data.spd.asfis.capabilities.NamesMappingImpl;
import org.gcube.data.spd.model.Condition;
import org.gcube.data.spd.model.RepositoryInfo;
import org.gcube.data.spd.model.products.DataProvider;
import org.gcube.data.spd.model.products.DataSet;
import org.gcube.data.spd.model.products.ResultItem;
import org.gcube.data.spd.model.products.Taxon;
import org.gcube.data.spd.model.util.Capabilities;
import org.gcube.data.spd.plugin.fwk.AbstractPlugin;
import org.gcube.data.spd.plugin.fwk.capabilities.ClassificationCapability;
import org.gcube.data.spd.plugin.fwk.capabilities.MappingCapability;
import org.gcube.data.spd.plugin.fwk.writers.ObjectWriter;


public class AsfisPlugin extends AbstractPlugin{
	
	public static String dbDriver = "org.postgresql.Driver";  

	public static String jdbc;
	public static String username ;
	public static String password;

//	public static String jdbc = "jdbc:postgresql://127.0.0.1:5432/asfis";
//	public static String username = "postgres";
//	public static String password = "";
	
	public static final String credits = "This information object has been generated via the Species Product Discovery service on XDATEX by interfacing with ASFIS List of Species for Fishery Statistics Purposes (http://www.fao.org/fishery/collection/asfis/en)";
	public static final String citation = "Accessed through: ASFIS List of Species for Fishery Statistics Purposes at http://www.fao.org/fishery/collection/asfis/en on ";
	public static final String xslFile = "/ASFIS.xls";
	public static final String table = "asfis";
	public static final String driver = "org.postgresql.Driver";

	public static final String SPA = "Spanish";
	public static final String FRA = "French";
	public static final String ENG = "English";
	public static final String DEFAULTRANK = "Species";
	public static final String ANIMALIA = "Animalia";
	public static final String FAMILY = "Family";
	public static final String ORDER = "Order";
	public static final String VALIDATED = "Validated";

	GCUBELog logger = new GCUBELog(AsfisPlugin.class);

	@Override
	public void initialize(ServiceEndpoint res) throws Exception {
		for (AccessPoint ap:res.profile().accessPoints()) {

			if (ap.name().equals("jdbc")) {
				jdbc = ap.address();	
				username = ap.username();	
				password = StringEncrypter.getEncrypter().decrypt(ap.password());
			}
		}
	}


	@Override
	public void update(ServiceEndpoint res) throws Exception {
		for (AccessPoint ap:res.profile().accessPoints()) {

			if (ap.name().equals("jdbc")) {
				jdbc = ap.address();	
				username = ap.username();
				password = ap.password();			
			}
		}
		super.update(res);
	}

	@Override
	public String getDescription() {
		return ("ASFIS Plugin");
	}

	@Override
	public String getRepositoryName() {
		return ("ASFIS");
	}

	@Override
	public void shutdown() throws Exception {
		//		Discover.shutdown();
	}


	@SuppressWarnings("serial")
	@Override
	public Set<Capabilities> getSupportedCapabilities() {
		return new HashSet<Capabilities>(){{add(Capabilities.Classification);add(Capabilities.NamesMapping);}};
	}

	@Override
	public ClassificationCapability getClassificationInterface() {
		return new ClassificationCapabilityImpl();
	}

	@Override
	public MappingCapability getMappingInterface() {
		return new NamesMappingImpl();
	}
	
	@Override
	public void searchByScientificName(String word,
			ObjectWriter<ResultItem> writer, Condition... properties) {

		ResultSet results = null;
		try{
			results = Utils.createResultSetByName(word);
			if (results!=null){

				while(results.next()) {	

//					TAXOCODE, Scientific_name, Author, Family, Order_rank 
					String id = results.getString(1);
					String scientific_name = results.getString(2);
					String author = results.getString(3);
					String family = results.getString(4);
					String order = results.getString(5);
					//common names
					String englishName = results.getString(6);
					String frenchName = results.getString(7);
					String spanishName = results.getString(8);
					

					ResultItem rs = null;
					try{
						rs = createResultItem(id, scientific_name, author, family, order, englishName, frenchName, spanishName);
					}catch (Exception e) {
						logger.error("Error retrieving information ", e);
					}

					if (writer.isAlive()){
						if (rs!=null)
							writer.write(rs);
					}
					else
						break;
				}
			}
		} catch (SQLException e) {
			logger.error("sql Error", e);
		}finally
		{
			try {
				if (results != null)
					results.close();
			} catch (SQLException ex) {
				logger.error("sql Error", ex);
			}
		}
	}





//	TAXOCODE, Scientific_name, Author, Family, Order_rank 
	private ResultItem createResultItem(String id, String ScName, String author, String family, String order, String englishName, String frenchName, String spanishName) {

		ResultItem item = new ResultItem(id, ScName);
		item.setRank("Species");
		item.setAuthor(author);
		
		//set common names
		item.setCommonNames(Utils.setCommonNames(englishName, frenchName, spanishName));
		
		//set credit and citation
		item.setCitation(Utils.createCitation());
		item.setCredits(Utils.createCredits());


		DataSet dataSet = new DataSet("ASFISid");
		dataSet.setName("ASFIS");
		DataProvider dp = new DataProvider("ASFISid");
		dp.setName("ASFIS");
		dataSet.setDataProvider(dp);
		item.setDataSet(dataSet);

		//set rank
		
		Taxon animaliaTaxon = new Taxon("Animalia", "Animalia");
		animaliaTaxon.setRank("Animalia");
		animaliaTaxon.setParent(null);
		
		Taxon familyTaxon = new Taxon(family, family);
		familyTaxon.setRank("Family");
		familyTaxon.setParent(animaliaTaxon);		
		
		Taxon orderTaxon = new Taxon(order, order);
		orderTaxon.setRank("Order");
		orderTaxon.setParent(familyTaxon);
				
		item.setParent(orderTaxon);	

		return item;	  
	}

	

	@Override
	public RepositoryInfo getRepositoryInfo() {
		RepositoryInfo info = new RepositoryInfo(
				"http://termportal.fao.org/faoas/as/pages/img/ftTermTitle_en.gif", 
				"http://www.fao.org/fishery/collection/asfis/en/",
				"The FAO Fisheries and Aquaculture Statistics and Information Service (FIPS) collates world capture and aquaculture production statistics at either the species, genus, family or higher taxonomic levels in 2 119 statistical categories (2011 data) referred to as species items.");
		return info;
	}


}



