/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.simulfishgrowthdata.util;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Scanner;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SocialNetworkingExecutor {
    static final Logger logger = LoggerFactory.getLogger(SocialNetworkingExecutor.class);
    static final String formatQueryParam = "&%s=%s";
    protected String mEndpoint;
    String mToken;

    public SocialNetworkingExecutor(String endpoint) {
        this.mEndpoint = endpoint;
    }

    public SocialNetworkingExecutor setToken(String token) {
        this.mToken = token;
        return this;
    }

    protected abstract String makeUri();

    protected abstract void prepareRequest(HttpUriRequest var1);

    protected abstract HttpUriRequest createRequest(URI var1);

    public void execute() throws Exception {
        this.processOutput(this.communicate(this.makeUri(), this.mToken));
    }

    private String communicate(String urlEndPoint, String token) throws Exception {
        URI uri = URI.create(urlEndPoint);
        if (logger.isTraceEnabled()) {
            logger.trace(String.format("calling uri [%s]", uri));
        }
        String toRet = "";
        HttpUriRequest request = this.createRequest(uri);
        request.addHeader("Accept", ContentType.APPLICATION_JSON.toString());
        request.addHeader("Content-type", ContentType.APPLICATION_JSON.toString());
        request.addHeader("gcube-token", this.mToken);
        this.prepareRequest(request);
        CloseableHttpClient httpclient = HttpClients.createDefault();
        CloseableHttpResponse resp = httpclient.execute(request);
        try {
            toRet = this.getContents(resp);
        }
        catch (RedirectException e) {
            logger.warn("When invoking [" + urlEndPoint + "] I was redirected to [" + e.getMessage() + "]. I will post there, as well");
            return this.communicate(e.getMessage(), token);
        }
        return toRet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getContents(CloseableHttpResponse resp) throws Exception {
        String exceptionMessage;
        String str;
        block12: {
            str = "";
            exceptionMessage = null;
            try {
                int status;
                StatusLine statusLine = resp.getStatusLine();
                if (logger.isTraceEnabled()) {
                    logger.trace(String.format("status line is [%s]", statusLine));
                }
                if (statusLine.getStatusCode() >= 300) {
                    exceptionMessage = "The server responded: " + statusLine.getReasonPhrase();
                }
                if ((status = statusLine.getStatusCode()) != 200 && (status == 302 || status == 301 || status == 303)) {
                    Header[] locations = resp.getHeaders("Location");
                    Header lastLocation = locations[locations.length - 1];
                    String realLocation = lastLocation.getValue();
                    logger.debug("Redirected. New location is " + realLocation);
                    throw new RedirectException(realLocation);
                }
                HttpEntity entity = resp.getEntity();
                if (entity == null) break block12;
                try (InputStream is = entity.getContent();){
                    Scanner s = new Scanner(is, StandardCharsets.UTF_8.name()).useDelimiter("\\A");
                    str = s.hasNext() ? s.next() : "";
                }
                if (logger.isTraceEnabled()) {
                    logger.trace(String.format("response is [%s]", str));
                }
            }
            finally {
                resp.close();
            }
        }
        if (logger.isTraceEnabled()) {
            logger.trace(String.format("contentes ~~~%s~~~", str));
        }
        if (exceptionMessage != null) {
            throw new Exception(exceptionMessage, new Exception(str));
        }
        return str;
    }

    protected Response processOutput(String output) throws Exception {
        return (Response)new Gson().fromJson(output, Response.class);
    }

    public static class RedirectException
    extends Exception {
        private static final long serialVersionUID = 5790392503222403601L;

        public RedirectException(String message) {
            super(message);
        }
    }

    public static class Response {
        public String success;
        public String message;
        public JsonObject result;

        public boolean isSuccess() {
            return "true".equals(this.success);
        }
    }
}

