/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.simulfishgrowthdata.util;

import gr.i2s.fishgrowth.model.SampleData;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.gcube.data.simulfishgrowthdata.util.ExcelReader;
import org.gcube.data.simulfishgrowthdata.util.UserFriendlyException;
import org.gcube.data.simulfishgrowthdata.util.Utils;
import org.hibernate.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelDataReader
extends ExcelReader {
    protected static final Logger logger = LoggerFactory.getLogger(ExcelDataReader.class);
    private static final double TEMPERATURE_OUT_OF_RANGE = 9999.0;
    int dateFromIdx = 0;
    int dateToIdx = 1;
    int openWeightIdx = 2;
    int closeWeightIdx = 3;
    int avgTemperatureIdx = 4;
    int openFishNoIdx = 5;
    int closeFishNoIdx = 6;
    int fcrIdx = 7;
    int mortalityRateIdx = 8;
    int sfrIdx = 9;
    int sgrIdx = 10;
    int headersCount = 1;

    protected ExcelDataReader() {
    }

    @Override
    protected void importWorkbook(Session session, long simulModelId, String uploadSource, Workbook workbook) {
        Sheet sheet = workbook.getSheetAt(0);
        if (logger.isTraceEnabled()) {
            logger.trace(String.format("Sheet 0 %s", sheet));
        }
        this.rawSheet(sheet);
        int rowcnt = 0;
        for (Row row : sheet) {
            logger.debug(String.format("Row [%s] ------------------------------------------------------", ++rowcnt));
            if (rowcnt <= this.headersCount) {
                logger.debug(String.format("Row [%s] is header (%s row are headers)", rowcnt, this.headersCount));
                continue;
            }
            try {
                SampleData data = new SampleData();
                data.setSimulModelId(simulModelId);
                data.setUploadSource(new Utils().limitLength(uploadSource, 99));
                data.setDateFrom(row.getCell(this.dateFromIdx).getDateCellValue());
                data.setDateTo(row.getCell(this.dateToIdx).getDateCellValue());
                data.setOpenWeight(row.getCell(this.openWeightIdx).getNumericCellValue());
                data.setCloseWeight(row.getCell(this.closeWeightIdx).getNumericCellValue());
                data.setAvgTemperature((int)row.getCell(this.avgTemperatureIdx).getNumericCellValue());
                data.setOpenFishNo((int)row.getCell(this.openFishNoIdx).getNumericCellValue());
                data.setCloseFishNo((int)row.getCell(this.closeFishNoIdx).getNumericCellValue());
                data.setFcr(row.getCell(this.fcrIdx).getNumericCellValue());
                data.setSfr(row.getCell(this.sfrIdx).getNumericCellValue());
                data.setSgr(row.getCell(this.sgrIdx).getNumericCellValue());
                data.setInclusion(1);
                Cell cell = row.getCell(this.mortalityRateIdx);
                if (cell.getCellTypeEnum() == CellType.BLANK) {
                    data.setMortalityRate(9999.0);
                } else {
                    data.setMortalityRate(cell.getNumericCellValue());
                }
                logger.debug(String.format("Inserting from row [%s] data [%s] ", rowcnt, data));
                session.save((Object)data);
            }
            catch (Exception e) {
                throw new RuntimeException(new UserFriendlyException("Error processing row [" + rowcnt + "]: " + e.getMessage(), e));
            }
        }
    }
}

