/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.simulfishgrowthdata.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.poi.EncryptedDocumentException;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.ss.util.CellReference;
import org.gcube.data.simulfishgrowthdata.util.ExcelDataReader;
import org.gcube.data.simulfishgrowthdata.util.ExcelLimitsReader;
import org.hibernate.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ExcelReader {
    public static int KIND_SAMPLE = 1;
    public static int KIND_LIMITS = 2;
    protected static final Logger logger = LoggerFactory.getLogger(ExcelReader.class);

    public static synchronized ExcelReader instance(int kind) {
        if (kind == KIND_SAMPLE) {
            return new ExcelDataReader();
        }
        if (kind == KIND_LIMITS) {
            return new ExcelLimitsReader();
        }
        throw new RuntimeException(String.format("Uknown kind [%s]", kind));
    }

    protected ExcelReader() {
    }

    public void importLocal(Session session, long simulModelId, String filename) throws EncryptedDocumentException, InvalidFormatException, IOException {
        this.importData(session, simulModelId, filename, new File(filename));
    }

    public void importRemote(Session session, long simulModelId, String fileUrl) throws EncryptedDocumentException, InvalidFormatException, MalformedURLException, IOException {
        this.importData(session, simulModelId, fileUrl, new URL(fileUrl.replace("https://", "http://")));
    }

    public void importData(Session session, long simulModelId, String uploadSource, URL fileUrl) throws IOException, EncryptedDocumentException, InvalidFormatException {
        if (logger.isTraceEnabled()) {
            logger.trace(String.format("Importing for simulModelId [%s] from [%s]", simulModelId, fileUrl));
        }
        Workbook workbook = WorkbookFactory.create((InputStream)fileUrl.openStream());
        this.importWorkbook(session, simulModelId, uploadSource, workbook);
        workbook.close();
    }

    public void importData(Session session, long simulModelId, String uploadSource, File file) throws IOException, EncryptedDocumentException, InvalidFormatException {
        if (logger.isTraceEnabled()) {
            logger.trace(String.format("Importing for simulModelId [%s] from [%s]", simulModelId, uploadSource));
        }
        Workbook workbook = WorkbookFactory.create((File)file);
        this.importWorkbook(session, simulModelId, file.getAbsolutePath(), workbook);
        workbook.close();
    }

    protected abstract void importWorkbook(Session var1, long var2, String var4, Workbook var5);

    public void rawSheet(Sheet sheet) {
        int rowcnt = 0;
        for (Row row : sheet) {
            logger.debug(String.format("Row [%s] ------------------------------------------------------", ++rowcnt));
            block8: for (Cell cell : row) {
                CellReference cellRef = new CellReference(row.getRowNum(), cell.getColumnIndex());
                logger.debug(String.format("CellRef [%s]", cellRef.formatAsString()));
                switch (cell.getCellTypeEnum()) {
                    case STRING: {
                        logger.debug(String.format("Value is string [%s]", cell.getRichStringCellValue().getString()));
                        continue block8;
                    }
                    case NUMERIC: {
                        if (DateUtil.isCellDateFormatted((Cell)cell)) {
                            logger.debug(String.format("Value is numeric - date formatted [%s]", cell.getDateCellValue()));
                            continue block8;
                        }
                        logger.debug(String.format("Value is numeric [%s]", cell.getNumericCellValue()));
                        continue block8;
                    }
                    case BOOLEAN: {
                        logger.debug(String.format("Value is boolean [%s]", cell.getBooleanCellValue()));
                        continue block8;
                    }
                    case FORMULA: {
                        logger.debug(String.format("Value is formula [%s]", cell.getCellFormula()));
                        continue block8;
                    }
                    case BLANK: {
                        logger.debug(String.format("Value is blank", new Object[0]));
                        continue block8;
                    }
                }
                logger.debug(String.format("Value without known CellType [%s] !!!", cell.getCellTypeEnum()));
            }
        }
    }
}

