/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.simulfishgrowthdata.calc;

import com.google.common.base.MoreObjects;
import gr.i2s.fishgrowth.Simulator.Executor;
import gr.i2s.fishgrowth.model.Scenario;
import java.text.SimpleDateFormat;
import java.util.Iterator;
import org.gcube.data.simulfishgrowthdata.calc.ScenarioExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsumptionScenarioExecutor
extends ScenarioExecutor {
    private static final Logger logger = LoggerFactory.getLogger(ConsumptionScenarioExecutor.class);

    public ConsumptionScenarioExecutor(Scenario scenario) {
        super(scenario);
        this.setDoSave(false);
        if (logger.isTraceEnabled()) {
            logger.trace(String.format("ctor", new Object[0]));
        }
    }

    @Override
    protected String processResults() {
        if (logger.isTraceEnabled()) {
            logger.trace(String.format("processing results", new Object[0]));
        }
        String toRet = new String();
        String tableSep = " , ";
        String noSep = "";
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd/MM/YY");
        String tableDaily = new String();
        String recordDaily = "{\"day\": \"%s\", \"bm\":%s, \"fcre\":%.2f, \"fcrb\":%.2f, \"food\":%s, \"bmdead\":%s, \"mortality\":%.5f }";
        int counterDay = 0;
        SimpleDateFormat monthFormat = new SimpleDateFormat("MM/YY");
        String tableMonthly = new String();
        String recordMonth = "{\"month\": \"%s\", \"food\":%s }";
        int counterMonth = 0;
        int curMonth = -1;
        int maxMonthDay = -1;
        double foodConsMonth = 0.0;
        Iterator iterator = this.dailyResults.iterator();
        while (iterator.hasNext()) {
            Executor.Daily daily = (Executor.Daily)iterator.next();
            String day = dateFormat.format(daily.date.getTime());
            String dayRec = String.format("{\"day\": \"%s\", \"bm\":%s, \"fcre\":%.2f, \"fcrb\":%.2f, \"food\":%s, \"bmdead\":%s, \"mortality\":%.5f }", day, new Double((double)daily.fishcount.intValue() * daily.mab).intValue(), daily.fcrEcon, daily.fcrBiol, Math.ceil(daily.food / 1000.0), daily.deadBM.intValue(), daily.mortality);
            if (logger.isTraceEnabled()) {
                logger.trace(String.format("adding day [%s]", dayRec));
            }
            tableDaily = tableDaily + (counterDay > 0 ? " , " : "") + dayRec;
            ++counterDay;
            if (daily.date.get(2) != curMonth) {
                foodConsMonth = 0.0;
                curMonth = daily.date.get(2);
                maxMonthDay = daily.date.getActualMaximum(5);
                if (logger.isTraceEnabled()) {
                    logger.trace(String.format("curMonth [%s] maxMonthDay [%s] foodConsMonth [%.2f]", curMonth, maxMonthDay, foodConsMonth));
                }
            }
            foodConsMonth += daily.food.doubleValue();
            if (daily.date.get(5) != maxMonthDay && iterator.hasNext()) continue;
            if (logger.isTraceEnabled()) {
                logger.trace(String.format("set month food [%.0f]", foodConsMonth));
            }
            String month = monthFormat.format(daily.date.getTime());
            String monthRec = String.format("{\"month\": \"%s\", \"food\":%s }", month, Math.ceil(foodConsMonth / 1000.0));
            if (logger.isTraceEnabled()) {
                logger.trace(String.format("adding month [%s]", monthRec));
            }
            tableMonthly = tableMonthly + (counterMonth > 0 ? " , " : "") + monthRec;
            ++counterMonth;
        }
        toRet = String.format("{\"daily\":[%s], \"monthly\":[%s]}", tableDaily, tableMonthly);
        if (logger.isTraceEnabled()) {
            logger.trace(String.format("after processing results returning [%s]", toRet));
        }
        return toRet;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).toString();
    }
}

