package org.gcube.data.simulfishgrowthdata.api.base;

import java.text.SimpleDateFormat;
import java.util.List;

import org.gcube.data.simulfishgrowthdata.calc.ConsumptionScenarioExecutor;
import org.gcube.data.simulfishgrowthdata.calc.ScenarioExecutor;
import org.gcube.data.simulfishgrowthdata.util.HibernateUtil;
import org.hibernate.Query;
import org.hibernate.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import gr.i2s.fishgrowth.model.Scenario;
public class ScenarioUtil extends BaseUtil {
	public Scenario add(Scenario scenario) throws Exception {
		Session session = null;

		try {
			session = HibernateUtil.openSession();

			session.beginTransaction();

			session.save(scenario);

			session.flush();

			session.getTransaction().commit();
			return scenario;
		} catch (Exception e) {
			logger.info(String.format("Could not add scenario [%s]", scenario), e);
			throw new Exception(String.format("Could not add scenario [%s]", scenario), e);
		} finally {
			HibernateUtil.closeSession(session);
		}
	}

	public Scenario update(Scenario scenario) throws Exception {
		Session session = null;

		try {
			session = HibernateUtil.openSession();

			session.beginTransaction();

			session.update(scenario);

			session.flush();

			session.getTransaction().commit();
			return scenario;
		} catch (Exception e) {
			logger.info(String.format("Could not update scenario [%s]", scenario), e);
			throw new Exception(String.format("Could not update scenario [%s]", scenario), e);
		} finally {
			HibernateUtil.closeSession(session);
		}
	}

	public boolean delete(Long id) throws Exception {
		Session session = null;

		try {
			session = HibernateUtil.openSession();

			session.beginTransaction();

			Scenario scenario = (Scenario) session.get(Scenario.class, Long.valueOf(id));

			if (scenario != null) {
				session.delete(scenario);

				session.flush();
			}

			session.getTransaction().commit();
			return true;
		} catch (Exception e) {
			logger.info(String.format("Could not delete scenario [%s]", id), e);
			return false;
		} finally {
			HibernateUtil.closeSession(session);
		}
	}

	public Scenario getScenario(Long id) throws Exception {
		Session session = null;

		try {
			session = HibernateUtil.openSession();

			session.beginTransaction();

			Scenario scenario = (Scenario) session.get(Scenario.class, Long.valueOf(id));

			session.getTransaction().commit();

			return scenario;
		} catch (Exception e) {
			logger.error(String.format("Could not retrieve scenario [%s]", id), e);
			throw new Exception(String.format("Could not retrieve scenario [%s]", id), e);
		} finally {
			HibernateUtil.closeSession(session);
		}
	}

	public List<Scenario> getScenarios(String ownerId) throws Exception {
		Session session = null;

		try {
			logger.trace(String.format("start getScenarios"));
			session = HibernateUtil.openSession();
			logger.trace(String.format("session [%s]", session));

			session.beginTransaction();

			Query q = session.createQuery(_GET_ALL_ON_OWNERID).setParameter("ownerid", ownerId);

			List<Scenario> list = q.list();

			session.getTransaction().commit();

			logger.trace(String.format("return Scenarios %s", list));
			return list;
		} catch (Exception e) {
			logger.info(String.format("Could not retrieve scenarios for [%s]", ownerId), e);
			throw new Exception(String.format("Could not retrieve scenarios for [%s]", ownerId), e);
		} finally {
			HibernateUtil.closeSession(session);
		}
	}

	public Scenario executeScenario(Long id) throws Exception {
		try {
			Scenario scenario = getScenario(id);
			if (logger.isTraceEnabled()) {
				logger.trace(String.format("For [%s] I loaded [%s]", id, scenario));
			}
			new ScenarioExecutor(scenario).run();
			return scenario;
		} catch (Exception e) {
			logger.info(String.format("Could not execute scenario [%s]", id), e);
			throw new Exception(String.format("Could not execute scenario [%s]", id), e);
		}
	}

	public String executeConsumptionScenario(String from, String to, Integer weight, Integer count, Long modelId)
			throws Exception {
		SimpleDateFormat df = new SimpleDateFormat("yyMMdd");
		Scenario scenario = new Scenario();
		scenario.setStartDate(df.parse(from));
		scenario.setTargetDate(df.parse(to));
		scenario.setWeight(weight / 100.0);
		scenario.setFishNo(count);
		scenario.setModelerId(modelId);
		ConsumptionScenarioExecutor executor = new ConsumptionScenarioExecutor(scenario);
		executor.run();
		return scenario.getResultsGraphData();
	}

	private static final String _GET_ALL_ON_OWNERID = "FROM gr.i2s.fishgrowth.model.Scenario s WHERE s.ownerId = :ownerid ORDER BY s.designation ASC";
	private static final Logger logger = LoggerFactory.getLogger(ScenarioUtil.class);
}
