/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.simulfishgrowthdata.api.base;

import com.google.common.base.Strings;
import gr.i2s.fishgrowth.model.Modeler;
import gr.i2s.fishgrowth.model.Usage;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.util.List;
import java.util.ListIterator;
import org.apache.poi.EncryptedDocumentException;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.gcube.data.simulfishgrowthdata.api.base.BaseUtil;
import org.gcube.data.simulfishgrowthdata.api.base.FcrUtil;
import org.gcube.data.simulfishgrowthdata.util.ExcelReader;
import org.gcube.data.simulfishgrowthdata.util.HibernateUtil;
import org.gcube.data.simulfishgrowthdata.util.UserFriendlyException;
import org.hibernate.Query;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelerUtil
extends BaseUtil {
    private static final String _GET_ALL_ON_OWNERID = "FROM gr.i2s.fishgrowth.model.Modeler s WHERE s.ownerId = :ownerid ORDER BY s.designation ASC";
    private static final String _GET_EXISTING_UPLOAD_SOURCE_SAMPLE = "SELECT DISTINCT uploadSource FROM gr.i2s.fishgrowth.model.SampleData s WHERE s.simulModelId = :simulModelId";
    private static final String _GET_EXISTING_UPLOAD_SOURCE_LIMITS = "SELECT DISTINCT uploadSource FROM gr.i2s.fishgrowth.model.WeightLimit s WHERE s.simulModelId = :simulModelId";
    private static final String _DELETE_ALL_SAMPLE_DATA = "DELETE FROM SampleData s WHERE s.simulModelId = :simulModelId";
    private static final String _DELETE_ALL_LIMITS_DATA = "DELETE FROM WeightLimit s WHERE s.simulModelId = :simulModelId";
    private static final String _GET_ALL_ON_SITE = "FROM gr.i2s.fishgrowth.model.Modeler s WHERE s.siteId = :siteid ORDER BY s.id ASC";
    private static final String _GET_USAGE_ON_OWNERID = "SELECT us.id as id, us.scenariocount as usage FROM simulusageview us inner join simulmodel e on (us.id=e.id) WHERE e.ownerId = :ownerid ORDER BY us.id ASC";
    private static final Logger logger = LoggerFactory.getLogger(ModelerUtil.class);

    public Modeler add(Modeler modeler) throws Exception {
        Session session = null;
        try {
            session = HibernateUtil.openSession();
            session.beginTransaction();
            session.save((Object)modeler);
            this.manageUploadFiles(session, modeler);
            session.flush();
            session.getTransaction().commit();
            Modeler modeler2 = modeler;
            return modeler2;
        }
        catch (Exception e) {
            logger.info(String.format("Could not add modeler [%s]", modeler), (Throwable)e);
            throw new Exception(String.format("Could not add modeler [%s]", modeler), e);
        }
        finally {
            HibernateUtil.closeSession(session);
        }
    }

    public Modeler update(Modeler modeler) throws Exception {
        Session session = null;
        try {
            session = HibernateUtil.openSession();
            session.beginTransaction();
            session.update((Object)modeler);
            this.manageUploadFiles(session, modeler);
            session.flush();
            session.getTransaction().commit();
            Modeler modeler2 = modeler;
            return modeler2;
        }
        catch (Exception e) {
            logger.info(String.format("Could not update modeler [%s]", modeler), (Throwable)e);
            throw new Exception(String.format("Could not update modeler [%s]", modeler), e);
        }
        finally {
            HibernateUtil.closeSession(session);
        }
    }

    public boolean delete(Long id) throws Exception {
        Session session = null;
        try {
            session = HibernateUtil.openSession();
            session.beginTransaction();
            if (this.doDelete(session, id)) {
                session.flush();
            }
            session.getTransaction().commit();
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            logger.info(String.format("Could not delete modeler [%s]", id), (Throwable)e);
            throw new Exception(String.format("Could not delete modeler [%s]", id), e);
        }
        finally {
            HibernateUtil.closeSession(session);
        }
    }

    public Modeler getModeler(Long id) throws Exception {
        Session session = null;
        try {
            session = HibernateUtil.openSession();
            session.beginTransaction();
            Modeler modeler = (Modeler)session.get(Modeler.class, (Serializable)id);
            session.getTransaction().commit();
            Modeler modeler2 = modeler;
            return modeler2;
        }
        catch (Exception e) {
            logger.info(String.format("Modeler not found [%s]", id), (Throwable)e);
            throw new Exception(String.format("Modeler not found [%s]", id), e);
        }
        finally {
            HibernateUtil.closeSession(session);
        }
    }

    public List<Modeler> getModelers(String ownerId, List<Long> statuses) throws Exception {
        List list;
        Session session = null;
        try {
            logger.trace(String.format("start getModelers", new Object[0]));
            session = HibernateUtil.openSession();
            logger.trace(String.format("session [%s]", session));
            session.beginTransaction();
            Query q = session.createQuery(_GET_ALL_ON_OWNERID).setParameter("ownerid", (Object)ownerId);
            List list2 = q.list();
            if (statuses != null && !statuses.isEmpty()) {
                ListIterator iter = list2.listIterator();
                while (iter.hasNext()) {
                    Modeler m = (Modeler)iter.next();
                    if (statuses.contains(m.getStatusId())) continue;
                    iter.remove();
                }
            }
            session.getTransaction().commit();
            logger.trace(String.format("return Modelers %s", list2));
            list = list2;
        }
        catch (Exception e) {
            try {
                logger.info(String.format("Could not retrieve modelers for [%s]", ownerId), (Throwable)e);
                throw new Exception(String.format("Could not retrieve modelers for [%s]", ownerId), e);
            }
            catch (Throwable throwable) {
                HibernateUtil.closeSession(session);
                throw throwable;
            }
        }
        HibernateUtil.closeSession(session);
        return list;
    }

    public void cleanKPIs(Long id) throws Exception {
        if (logger.isTraceEnabled()) {
            logger.trace(String.format("cleaning KPIs for model %s", id));
        }
        Session session = null;
        try {
            session = HibernateUtil.openSession();
            logger.trace(String.format("session [%s]", session));
            session.beginTransaction();
            this.doCleanKPIs(session, id);
            session.getTransaction().commit();
        }
        catch (Exception e) {
            logger.info(String.format("Could not clean KPIs for model [%s]", id), (Throwable)e);
            throw new Exception(String.format("Could not clean KPIs for model [%s]", id), e);
        }
        finally {
            HibernateUtil.closeSession(session);
        }
    }

    public void doCleanKPIs(Session session, Long id) {
        new FcrUtil().doDeleteAll(session, id);
    }

    private String importRemote(Session session, int kind, long id, String uploadFileType, String uploadFileLocation) throws EncryptedDocumentException, InvalidFormatException, MalformedURLException, IOException {
        if (kind == ExcelReader.KIND_SAMPLE && !Strings.isNullOrEmpty((String)uploadFileType)) {
            if ("xls".equalsIgnoreCase(uploadFileType) || "xlsx".equalsIgnoreCase(uploadFileType)) {
                ExcelReader.instance(ExcelReader.KIND_SAMPLE).importRemote(session, id, uploadFileLocation);
                return uploadFileLocation;
            }
            logger.error(String.format("uknown type [%s] for id [%s]", uploadFileType, id));
        }
        if (kind == ExcelReader.KIND_LIMITS && !Strings.isNullOrEmpty((String)uploadFileType)) {
            if ("xls".equalsIgnoreCase(uploadFileType) || "xlsx".equalsIgnoreCase(uploadFileType)) {
                ExcelReader.instance(ExcelReader.KIND_LIMITS).importRemote(session, id, uploadFileLocation);
                return uploadFileLocation;
            }
            logger.error(String.format("uknown type [%s] for id [%s]", uploadFileType, id));
        }
        return null;
    }

    private void manageUploadFiles(Session session, Modeler modeler) throws UserFriendlyException {
        try {
            this.manageUploadFile(session, modeler.getId(), ExcelReader.KIND_SAMPLE, modeler.getUploadFileTypeData(), modeler.getUploadFileLocationData());
        }
        catch (Exception e) {
            throw new UserFriendlyException("Could not upload SampleData file", e);
        }
        try {
            this.manageUploadFile(session, modeler.getId(), ExcelReader.KIND_LIMITS, modeler.getUploadFileTypeWeights(), modeler.getUploadFileLocationWeights());
        }
        catch (Exception e) {
            throw new UserFriendlyException("Could not upload WeightCategories file", e);
        }
    }

    private void manageUploadFile(Session session, long id, int kind, String type, String location) throws InvalidFormatException, MalformedURLException, IOException {
        if (logger.isTraceEnabled()) {
            logger.trace(String.format("managing upload data file for [%s], of type [%s], located at [%s]", id, type, location));
        }
        String uploadData = Strings.nullToEmpty((String)location);
        String existingSQL = kind == ExcelReader.KIND_SAMPLE ? _GET_EXISTING_UPLOAD_SOURCE_SAMPLE : _GET_EXISTING_UPLOAD_SOURCE_LIMITS;
        Query qUploadSource = session.createQuery(existingSQL).setParameter("simulModelId", (Object)id);
        List existingUploadSource = qUploadSource.list();
        if (logger.isTraceEnabled()) {
            logger.trace(String.format("existing uploads for %s are [%s]", id, existingUploadSource));
        }
        if (!existingUploadSource.isEmpty()) {
            if (uploadData.equals(existingUploadSource.get(0))) {
                if (logger.isTraceEnabled()) {
                    logger.trace(String.format("upload data file for %s set to same value; bypassing", id));
                }
                return;
            }
            int recsCleaned = kind == ExcelReader.KIND_SAMPLE ? this.doCleanSampleData(session, id) : this.doCleanWeightLimits(session, id);
            if (logger.isTraceEnabled()) {
                logger.trace(String.format("upload data file for [%s] changed; erased [%s] mismatching records", id, recsCleaned));
            }
        }
        if (!Strings.isNullOrEmpty((String)uploadData)) {
            this.importRemote(session, kind, id, type, uploadData);
        }
    }

    public List<Modeler> getModelersForSite(Session session, Long siteid) {
        try {
            logger.trace(String.format("start getModelersForSites", new Object[0]));
            Query q = session.createQuery(_GET_ALL_ON_SITE).setParameter("siteid", (Object)siteid);
            List list = q.list();
            logger.trace(String.format("return Modelers %s", list));
            return list;
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Could not retrieve modelers for site [%s]", siteid), e);
        }
    }

    public int doCleanSampleData(Session session, Long id) {
        SQLQuery q = session.createSQLQuery(_DELETE_ALL_SAMPLE_DATA);
        q.setParameter("simulModelId", (Object)id);
        return q.executeUpdate();
    }

    public int doCleanWeightLimits(Session session, Long id) {
        SQLQuery q = session.createSQLQuery(_DELETE_ALL_LIMITS_DATA);
        q.setParameter("simulModelId", (Object)id);
        return q.executeUpdate();
    }

    public boolean doDelete(Session session, Long id) {
        try {
            return this.doDelete(session, (Modeler)session.get(Modeler.class, (Serializable)id));
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Could not delete Modeler with id [%s]", id), e);
        }
    }

    public boolean doDelete(Session session, Modeler modeler) {
        try {
            if (modeler == null) {
                return false;
            }
            this.doCleanSampleData(session, modeler.getId());
            this.doCleanWeightLimits(session, modeler.getId());
            this.doCleanKPIs(session, modeler.getId());
            session.delete((Object)modeler);
            return true;
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Could not delete Modeler  [%s]", modeler), e);
        }
    }

    public List<Usage> getUsage(String ownerId) throws Exception {
        List list;
        Session session = null;
        try {
            logger.trace(String.format("start getUsage", new Object[0]));
            session = HibernateUtil.openSession();
            logger.trace(String.format("session [%s]", session));
            session.beginTransaction();
            Query q = session.createSQLQuery(_GET_USAGE_ON_OWNERID).addEntity(Usage.class).setParameter("ownerid", (Object)ownerId);
            List list2 = q.list();
            session.getTransaction().commit();
            logger.trace(String.format("return site usage %s", list2));
            list = list2;
        }
        catch (Exception e) {
            try {
                logger.error(String.format("Could not retrieve site usage for ownerid [%s]", ownerId), (Throwable)e);
                throw new Exception(String.format("Could not retrieve site usage for ownerid [%s]", ownerId), e);
            }
            catch (Throwable throwable) {
                HibernateUtil.closeSession(session);
                throw throwable;
            }
        }
        HibernateUtil.closeSession(session);
        return list;
    }
}

