/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datapublishing.sdmx.impl.model;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gcube.common.resources.gcore.ServiceEndpoint;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.datapublishing.sdmx.api.model.SDMXRegistryDescriptor;
import org.gcube.datapublishing.sdmx.api.model.SDMXRegistryInterfaceType;
import org.gcube.datapublishing.sdmx.impl.model.SDMXRegistryDescriptorImpl;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.impl.XQuery;
import org.gcube.resources.discovery.icclient.ICFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GCubeSDMXRegistryDescriptor
implements SDMXRegistryDescriptor {
    private Logger log = LoggerFactory.getLogger(GCubeSDMXRegistryDescriptor.class);
    private Map<String, SDMXRegistryDescriptor> delegates = new HashMap<String, SDMXRegistryDescriptor>();

    public String getUrl(SDMXRegistryInterfaceType interfaceType) {
        String scope = ScopeProvider.instance.get();
        if (scope == null || scope.isEmpty()) {
            this.log.error("No scope provided, unable to retrieve SDMX registry");
            return null;
        }
        if (!this.dataRetrieved(scope)) {
            this.delegates.put(scope, this.retrieveDescriptor());
        }
        return this.delegates.get(scope).getUrl(interfaceType);
    }

    private boolean dataRetrieved(String scope) {
        return this.delegates.containsKey(ScopeProvider.instance.get());
    }

    private SDMXRegistryDescriptor retrieveDescriptor() {
        XQuery query = ICFactory.queryFor(ServiceEndpoint.class);
        String scope = ScopeProvider.instance.get();
        this.log.debug("Looking for SDMXRegistry resources on scope: " + scope);
        query.addCondition("$resource/Profile/Category/text() eq 'SDMX'");
        query.addCondition("$resource/Profile/Name/text() eq 'SDMXRegistry'");
        DiscoveryClient client = ICFactory.clientFor(ServiceEndpoint.class);
        List resources = client.submit((Query)query);
        if (resources.size() > 1 || resources.isEmpty()) {
            this.log.error("Invalid number of SDMX registry resources found: " + resources.size());
            return null;
        }
        SDMXRegistryDescriptorImpl descriptor = new SDMXRegistryDescriptorImpl();
        for (ServiceEndpoint.AccessPoint ap : ((ServiceEndpoint)resources.get(0)).profile().accessPoints()) {
            this.log.trace("Retrieved " + ap.name() + ": " + ap.address());
            if (ap.name().equals(RegistryInterfaceCode.RESTV1.toString())) {
                descriptor.setUrl(SDMXRegistryInterfaceType.RESTV1, ap.address());
            }
            if (ap.name().equals(RegistryInterfaceCode.RESTV2.toString())) {
                descriptor.setUrl(SDMXRegistryInterfaceType.RESTV2, ap.address());
            }
            if (ap.name().equals(RegistryInterfaceCode.RESTV2_1.toString())) {
                descriptor.setUrl(SDMXRegistryInterfaceType.RESTV2_1, ap.address());
            }
            if (ap.name().equals(RegistryInterfaceCode.SOAPV1.toString())) {
                descriptor.setUrl(SDMXRegistryInterfaceType.SOAPV1, ap.address());
            }
            if (ap.name().equals(RegistryInterfaceCode.SOAPV2.toString())) {
                descriptor.setUrl(SDMXRegistryInterfaceType.SOAPV2, ap.address());
            }
            if (!ap.name().equals(RegistryInterfaceCode.SOAPV2_1.toString())) continue;
            descriptor.setUrl(SDMXRegistryInterfaceType.SOAPV2_1, ap.address());
        }
        this.log.debug("SDMX registry resource retrieved from IS: " + descriptor);
        return descriptor;
    }

    private static enum RegistryInterfaceCode {
        RESTV1,
        RESTV2,
        RESTV2_1,
        SOAPV1,
        SOAPV2,
        SOAPV2_1;

    }
}

