/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datapublishing.sdmx.impl.publisher;

import java.io.InputStream;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.datapublishing.sdmx.api.datasource.GCubeSDMXDatasourceClient;
import org.gcube.datapublishing.sdmx.api.model.GCubeSDMXDatasourceDescriptor;
import org.gcube.datapublishing.sdmx.api.publisher.GCubeSDMXPublisher;
import org.gcube.datapublishing.sdmx.api.registry.SDMXRegistryClient;
import org.gcube.datapublishing.sdmx.impl.exceptions.SDMXRegistryClientException;
import org.gcube.datapublishing.sdmx.impl.publisher.data.LocalizedText;
import org.gcube.datapublishing.sdmx.impl.publisher.exceptions.PublisherException;
import org.sdmxsource.sdmx.api.constants.TERTIARY_BOOL;
import org.sdmxsource.sdmx.api.model.beans.SdmxBeans;
import org.sdmxsource.sdmx.api.model.beans.base.AgencySchemeBean;
import org.sdmxsource.sdmx.api.model.beans.base.DataProviderSchemeBean;
import org.sdmxsource.sdmx.api.model.beans.codelist.CodelistBean;
import org.sdmxsource.sdmx.api.model.beans.conceptscheme.ConceptSchemeBean;
import org.sdmxsource.sdmx.api.model.beans.datastructure.DataStructureBean;
import org.sdmxsource.sdmx.api.model.beans.datastructure.DataflowBean;
import org.sdmxsource.sdmx.api.model.beans.reference.MaintainableRefBean;
import org.sdmxsource.sdmx.api.model.beans.registry.ProvisionAgreementBean;
import org.sdmxsource.sdmx.api.model.mutable.base.AgencyMutableBean;
import org.sdmxsource.sdmx.api.model.mutable.base.AgencySchemeMutableBean;
import org.sdmxsource.sdmx.api.model.mutable.base.DataSourceMutableBean;
import org.sdmxsource.sdmx.api.model.mutable.base.ItemMutableBean;
import org.sdmxsource.sdmx.api.model.mutable.registry.RegistrationMutableBean;
import org.sdmxsource.sdmx.sdmxbeans.model.mutable.base.AgencyMutableBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.mutable.base.DataSourceMutableBeanImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class GCubeSDMXPublisherImpl
implements GCubeSDMXPublisher {
    private static final Logger log = LoggerFactory.getLogger(GCubeSDMXPublisherImpl.class);
    private SDMXRegistryClient registryClient;
    private GCubeSDMXDatasourceClient datasourceClient;
    private GCubeSDMXDatasourceDescriptor datasourceDescriptor;
    private static String ROOT_AGENCY_SCHEME_FILENAME = "rootAgencyScheme.properties";
    private Properties props = null;

    @Autowired
    public GCubeSDMXPublisherImpl(SDMXRegistryClient registryClient, GCubeSDMXDatasourceClient datasourceClient, GCubeSDMXDatasourceDescriptor datasourceDescriptor) {
        this.registryClient = registryClient;
        this.datasourceClient = datasourceClient;
        this.datasourceDescriptor = datasourceDescriptor;
    }

    private void loadAgencyRootSchemeProperties() throws PublisherException {
        if (this.props != null) {
            return;
        }
        try {
            this.props = new Properties();
            InputStream is = this.getClass().getClassLoader().getResourceAsStream(ROOT_AGENCY_SCHEME_FILENAME);
            log.debug("Properties file InputStream:" + is);
            this.props.load(is);
        }
        catch (Exception e) {
            log.error("Unable to find Root Agency Scheme coordinates file ('" + ROOT_AGENCY_SCHEME_FILENAME + "')");
            throw new PublisherException("Unable to find Root Agency Scheme coordinates file");
        }
    }

    @Override
    public void createAgency(String agencyId, List<LocalizedText> names) throws PublisherException {
        SdmxBeans beans;
        this.loadAgencyRootSchemeProperties();
        log.debug("Properties file: " + this.props);
        String schemaAgencyId = this.props.getProperty("agencyId");
        String schemaId = this.props.getProperty("artifactId");
        String schemaVersion = this.props.getProperty("version");
        log.debug("Retrieved Agency Scheme coordinates from properties file: [" + schemaAgencyId + ", " + schemaId + ", " + schemaVersion + "]");
        try {
            beans = this.registryClient.getAgencyScheme(schemaAgencyId, schemaId, schemaVersion, SDMXRegistryClient.Detail.full, SDMXRegistryClient.References.none);
        }
        catch (SDMXRegistryClientException e) {
            String errorMsg = "Unable to find the root agency scheme";
            log.error(errorMsg, (Throwable)e);
            throw new PublisherException(errorMsg, e);
        }
        Set agencies = beans.getAgenciesSchemes();
        if (agencies.size() != 1) {
            throw new PublisherException("Invalid number of root agency schemas retrieved from IS");
        }
        AgencySchemeMutableBean rootAgencyScheme = ((AgencySchemeBean)agencies.iterator().next()).getMutableInstance();
        for (AgencyMutableBean agency : rootAgencyScheme.getItems()) {
            if (!agency.getId().equals(agencyId)) continue;
            log.debug("Agency with id '" + agencyId + "' already present");
            return;
        }
        if (rootAgencyScheme.getFinalStructure() == TERTIARY_BOOL.TRUE) {
            throw new PublisherException("Unable to modify root Agency Scheme, artifact is marked as Final");
        }
        log.debug("Agency with id '" + agencyId + "' not found in root agency schema, creating a new one...");
        AgencyMutableBeanImpl newAgency = new AgencyMutableBeanImpl();
        newAgency.setId(agencyId);
        for (LocalizedText localizedText : names) {
            newAgency.addName(localizedText.getLocale(), localizedText.getText());
        }
        log.debug("Submitting modified root agency schema");
        rootAgencyScheme.addItem((ItemMutableBean)newAgency);
        try {
            this.registryClient.publish(rootAgencyScheme.getImmutableInstance());
        }
        catch (SDMXRegistryClientException e) {
            log.error("SDMXRegistryClientException caught while publishing modified root agency schema", (Throwable)e);
            throw new PublisherException(e.getMessage());
        }
    }

    @Override
    public void publish(CodelistBean codelist) throws PublisherException {
        try {
            this.registryClient.publish(codelist);
        }
        catch (SDMXRegistryClientException e) {
            throw new PublisherException(e);
        }
    }

    @Override
    public void publish(ConceptSchemeBean conceptscheme) throws PublisherException {
        try {
            this.registryClient.publish(conceptscheme);
        }
        catch (SDMXRegistryClientException e) {
            throw new PublisherException(e);
        }
    }

    @Override
    public void publish(DataStructureBean datastructure) throws PublisherException {
        try {
            this.registryClient.publish(datastructure);
        }
        catch (SDMXRegistryClientException e) {
            throw new PublisherException(e);
        }
    }

    @Override
    public void publish(DataflowBean dataflow) throws PublisherException {
        try {
            this.registryClient.publish(dataflow);
        }
        catch (SDMXRegistryClientException e) {
            throw new PublisherException(e);
        }
    }

    @Override
    public void publish(DataProviderSchemeBean dataproviderscheme) throws PublisherException {
        try {
            this.registryClient.publish(dataproviderscheme);
        }
        catch (SDMXRegistryClientException e) {
            throw new PublisherException(e);
        }
    }

    @Override
    public void publish(ProvisionAgreementBean provisionagreement) throws PublisherException {
        try {
            this.registryClient.publish(provisionagreement);
        }
        catch (SDMXRegistryClientException e) {
            throw new PublisherException(e);
        }
    }

    @Override
    public void publish(RegistrationMutableBean registration, String timeseriesId, String timeseriesServiceScope) throws PublisherException {
        TimeseriesRegistrationData tsrd = this.getTimeseriesRegistrationData(registration.getProvisionAgreementRef().getMaintainableReference());
        String currentScope = ScopeProvider.instance.get();
        try {
            this.datasourceClient.registerTimeseries(tsrd.getFlowAgencyId(), tsrd.getFlowId(), tsrd.flowVersion, tsrd.getProviderAgencyId(), tsrd.getProviderId(), timeseriesId, currentScope, currentScope);
        }
        catch (Exception e) {
            String errorMsg = "Unable to register timeseries on sdmx datasource";
            log.error(errorMsg, (Throwable)e);
            throw new PublisherException(errorMsg);
        }
        DataSourceMutableBeanImpl dataSource = new DataSourceMutableBeanImpl();
        dataSource.setRESTDatasource(true);
        dataSource.setWebServiceDatasource(false);
        dataSource.setSimpleDatasource(false);
        dataSource.setDataUrl(this.datasourceDescriptor.getRest_url_V2_1());
        registration.setDataSource((DataSourceMutableBean)dataSource);
        try {
            this.registryClient.publish(registration.getImmutableInstance());
        }
        catch (SDMXRegistryClientException e) {
            String errorMsg = "Unable to publish registration on sdmx registry";
            log.error(errorMsg, (Throwable)e);
            throw new PublisherException(errorMsg);
        }
    }

    private TimeseriesRegistrationData getTimeseriesRegistrationData(MaintainableRefBean provisionAgreementRef) throws PublisherException {
        SdmxBeans beans;
        try {
            beans = this.registryClient.getProvisionAgreement(provisionAgreementRef.getAgencyId(), provisionAgreementRef.getMaintainableId(), provisionAgreementRef.getVersion(), SDMXRegistryClient.Detail.full, SDMXRegistryClient.References.none);
        }
        catch (SDMXRegistryClientException e) {
            String errorMsg = "Unable to retrieve provision agreement from sdmx registry with reference: " + provisionAgreementRef;
            log.error(errorMsg, (Throwable)e);
            throw new PublisherException(errorMsg);
        }
        TimeseriesRegistrationData result = new TimeseriesRegistrationData();
        ProvisionAgreementBean pa = (ProvisionAgreementBean)beans.getProvisionAgreements().iterator().next();
        MaintainableRefBean dataflowRef = pa.getStructureUseage().getMaintainableReference();
        result.setFlowAgencyId(dataflowRef.getAgencyId());
        result.setFlowId(dataflowRef.getMaintainableId());
        result.setFlowVersion(dataflowRef.getVersion());
        result.setProviderAgencyId(pa.getDataproviderRef().getMaintainableReference().getAgencyId());
        result.setProviderId(pa.getDataproviderRef().getIdentifiableIds()[0]);
        log.trace("Built: " + result);
        return result;
    }

    private class TimeseriesRegistrationData {
        String flowAgencyId;
        String flowId;
        String flowVersion;
        String providerAgencyId;
        String providerId;

        public String getFlowAgencyId() {
            return this.flowAgencyId;
        }

        public String getFlowId() {
            return this.flowId;
        }

        public String getFlowVersion() {
            return this.flowVersion;
        }

        public String getProviderAgencyId() {
            return this.providerAgencyId;
        }

        public String getProviderId() {
            return this.providerId;
        }

        public void setFlowAgencyId(String flowAgencyId) {
            this.flowAgencyId = flowAgencyId;
        }

        public void setFlowId(String flowId) {
            this.flowId = flowId;
        }

        public void setFlowVersion(String flowVersion) {
            this.flowVersion = flowVersion;
        }

        public void setProviderAgencyId(String providerAgencyId) {
            this.providerAgencyId = providerAgencyId;
        }

        public void setProviderId(String providerId) {
            this.providerId = providerId;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TimeseriesRegistrationData)) {
                return false;
            }
            TimeseriesRegistrationData other = (TimeseriesRegistrationData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$flowAgencyId = this.getFlowAgencyId();
            String other$flowAgencyId = other.getFlowAgencyId();
            if (this$flowAgencyId == null ? other$flowAgencyId != null : !this$flowAgencyId.equals(other$flowAgencyId)) {
                return false;
            }
            String this$flowId = this.getFlowId();
            String other$flowId = other.getFlowId();
            if (this$flowId == null ? other$flowId != null : !this$flowId.equals(other$flowId)) {
                return false;
            }
            String this$flowVersion = this.getFlowVersion();
            String other$flowVersion = other.getFlowVersion();
            if (this$flowVersion == null ? other$flowVersion != null : !this$flowVersion.equals(other$flowVersion)) {
                return false;
            }
            String this$providerAgencyId = this.getProviderAgencyId();
            String other$providerAgencyId = other.getProviderAgencyId();
            if (this$providerAgencyId == null ? other$providerAgencyId != null : !this$providerAgencyId.equals(other$providerAgencyId)) {
                return false;
            }
            String this$providerId = this.getProviderId();
            String other$providerId = other.getProviderId();
            return !(this$providerId == null ? other$providerId != null : !this$providerId.equals(other$providerId));
        }

        public boolean canEqual(Object other) {
            return other instanceof TimeseriesRegistrationData;
        }

        public int hashCode() {
            int PRIME = 31;
            int result = 1;
            String $flowAgencyId = this.getFlowAgencyId();
            result = result * 31 + ($flowAgencyId == null ? 0 : $flowAgencyId.hashCode());
            String $flowId = this.getFlowId();
            result = result * 31 + ($flowId == null ? 0 : $flowId.hashCode());
            String $flowVersion = this.getFlowVersion();
            result = result * 31 + ($flowVersion == null ? 0 : $flowVersion.hashCode());
            String $providerAgencyId = this.getProviderAgencyId();
            result = result * 31 + ($providerAgencyId == null ? 0 : $providerAgencyId.hashCode());
            String $providerId = this.getProviderId();
            result = result * 31 + ($providerId == null ? 0 : $providerId.hashCode());
            return result;
        }

        public String toString() {
            return "GCubeSDMXPublisherImpl.TimeseriesRegistrationData(flowAgencyId=" + this.getFlowAgencyId() + ", flowId=" + this.getFlowId() + ", flowVersion=" + this.getFlowVersion() + ", providerAgencyId=" + this.getProviderAgencyId() + ", providerId=" + this.getProviderId() + ")";
        }
    }
}

