package org.gcube.datapublishing.sdmx.impl.repository.dao;

import java.util.List;

import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.NoResultException;
import javax.persistence.Persistence;
import javax.persistence.TypedQuery;

import lombok.extern.slf4j.Slf4j;

import org.gcube.datapublishing.sdmx.api.repository.dao.RegistrationDAO;

@Slf4j
public class RegistrationDAOImpl implements RegistrationDAO {

	private EntityManager em;

	public RegistrationDAOImpl() {
		
		EntityManagerFactory factory = Persistence
				.createEntityManagerFactory("default");
		em = factory.createEntityManager();
	}

	@Override
	public void insertRegistration(Registration r) {
		Registration tmp = getRegistration(r.getFlowAgencyId(), r.getFlowId(),
				r.getFlowVersion(), r.getProviderAgencyId(), r.getProviderId());
		if (tmp == null) {
			try {
				log.debug("Adding Timseries registration to DB: " + r);
				em.getTransaction().begin();
				em.persist(r);
				em.getTransaction().commit();
			} catch (Exception e) {
				log.warn("Caught error from EntityManager", e);
			}
		} else
			log.warn("Registration already present in DB: " + r);
	}

	@Override
	public List<Registration> getAllRegistrations() {
		TypedQuery<Registration> q = em.createNamedQuery(
				"Registration.findAll", Registration.class);
		return q.getResultList();
	}

	@Override
	public List<Registration> getRegistrationsByFlowId(String flowId) {
		TypedQuery<Registration> q = em.createNamedQuery(
				"Registration.findByFlowId", Registration.class);
		q.setParameter("flowId", flowId);
		return q.getResultList();
	}

	@Override
	public List<Registration> getRegistrationsByFlow(String flowAgencyId,
			String flowId, String flowVersion) {
		TypedQuery<Registration> q = em.createNamedQuery(
				"Registration.findByFlow", Registration.class);
		q.setParameter("flowAgencyId", flowAgencyId);
		q.setParameter("flowId", flowId);
		q.setParameter("flowVersion", flowVersion);
		return q.getResultList();
	}

	@Override
	public Registration getRegistration(String flowAgencyId, String flowId,
			String flowVersion, String providerAgencyId, String providerId) {
		TypedQuery<Registration> q = em.createNamedQuery(
				"Registration.findRegistration", Registration.class);
		q.setParameter("flowAgencyId", flowAgencyId);
		q.setParameter("flowId", flowId);
		q.setParameter("flowVersion", flowVersion);
		q.setParameter("providerAgencyId", providerAgencyId);
		q.setParameter("providerId", providerId);

		try {
			return q.getSingleResult();
		} catch (NoResultException e) {
			return null;
		}

	}

	@Override
	public boolean removeRegistration(String flowAgencyId, String flowId,
			String flowVersion, String providerAgencyId, String providerId) {
		Registration r = getRegistration(flowAgencyId, flowId, flowVersion,
				providerAgencyId, providerId);
		if (r != null) {
			log.debug("Removing Timeseries registration from DB: " + r);
			em.getTransaction().begin();
			em.remove(r);
			em.getTransaction().commit();
			return true;
		}
		return false;
	}
}
