package org.gcube.datapublishing.sdmx.rest;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;

import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.Response.Status;

import lombok.extern.slf4j.Slf4j;

import org.gcube.datapublishing.sdmx.api.repository.GCubeSDMXDataRepository;
import org.gcube.datapublishing.sdmx.impl.data.TimeseriesRegistration;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Slf4j
@Component
@Scope("singleton")
@Path("/registration")
public class RegistrationResource {

	@Autowired
	private GCubeSDMXDataRepository repository;

	@POST
	@Consumes(MediaType.APPLICATION_XML)
	@Produces(MediaType.APPLICATION_XML)
	public Response registerTimeseries(TimeseriesRegistration r) {
		try {
			repository.registerTimeseries(r);
		} catch (Exception e) {
			log.error("Error registering timeseries", e);
			return Response.status(Status.INTERNAL_SERVER_ERROR)
					.entity(e.getMessage()).build();
		}
		URI resourceURI;
		try {
			resourceURI = new URI("/registration/" + r.getFlowAgencyId() + "/"
					+ r.getFlowId() + "/" + r.getFlowVersion() + "/"
					+ r.getProviderAgencyId() + "/" + r.getProviderId());
		} catch (URISyntaxException e) {
			log.error("Generate invalid resource URI");
			return Response.status(Status.INTERNAL_SERVER_ERROR)
					.entity(e.getMessage()).build();
		}
		return Response.created(resourceURI).entity(r).build();
	}

	@GET
	@Produces(MediaType.APPLICATION_XML)
	public ArrayList<TimeseriesRegistration> getTimeseriesRegistrations() {
		try {
			ArrayList<TimeseriesRegistration> result = new ArrayList<TimeseriesRegistration>(
					repository.getRegistrations());
			return result;
		} catch (Exception e) {
			log.error("Unable to retrieve registrations", e);
			throw new WebApplicationException(Response.status(Status.INTERNAL_SERVER_ERROR).entity("Unable to retrieve registrations").build());
		}
	}
	
	@DELETE
	@Path("{flowAgencyId}/{flowId}/{flowVersion}/{providerAgencyId}/{providerId}")
	public Response deleteTimeseriesRegistration(@PathParam("flowAgencyId") String flowAgencyId, @PathParam("flowId") String flowId, @PathParam("flowVersion") String flowVersion, @PathParam("providerAgencyId") String providerAgencyId, @PathParam("providerId") String providerId) {
		boolean removed = repository.removeRegistration(flowAgencyId, flowId, flowVersion, providerAgencyId, providerId);
		if (removed) return Response.status(204).build();
		return Response.status(404).build();
	}

}
