/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datapublishing.sdmx.datasource.tabman;

import org.gcube.data.analysis.tabulardata.service.TabularDataService;
import org.gcube.data.analysis.tabulardata.service.impl.TabularDataServiceFactory;
import org.gcube.datapublishing.sdmx.datasource.data.ResultSetExtractor;
import org.gcube.datapublishing.sdmx.datasource.data.utils.SdmxDataWriter;
import org.gcube.datapublishing.sdmx.datasource.tabman.querymanager.impl.TabmanDataRetriever;
import org.gcube.datapublishing.sdmx.datasource.tabman.querymanager.impl.TabmanQuery;
import org.gcube.datapublishing.sdmx.datasource.tabman.querymanager.impl.TabmanResultSetExtractor;
import org.gcube.datapublishing.sdmx.datasource.tabman.querymanager.json.Rows;
import org.gcube.datapublishing.sdmx.datasource.tabman.querymanager.json.exception.SDMXDataException;
import org.sdmxsource.sdmx.api.engine.DataWriterEngine;
import org.sdmxsource.sdmx.api.manager.retrieval.data.SdmxDataRetrievalWithWriter;
import org.sdmxsource.sdmx.api.model.beans.base.TextTypeWrapper;
import org.sdmxsource.sdmx.api.model.data.query.DataQuery;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.base.TextTypeWrapperImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.data.FooterMessageImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TabularDataRetrievalManager
implements SdmxDataRetrievalWithWriter {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public void getData(DataQuery dataQuery, DataWriterEngine dataWriter) {
        TabularDataService service = TabularDataServiceFactory.getService();
        String dataStructureid = dataQuery.getDataStructure().getId();
        this.logger.debug("Data structure id " + dataStructureid);
        try {
            TabmanDataRetriever dataRetriever = new TabmanDataRetriever(dataQuery, service);
            TabmanQuery query = dataRetriever.buildDataQuery();
            this.logger.debug("Query generated");
            this.logger.debug("Adding SDMX elements to rs extractor");
            this.logger.debug("Data Writer " + dataWriter.getClass());
            this.logger.debug("Data Query " + dataQuery);
            ResultSetExtractor resultSetExtractor = dataRetriever.generateResultSetExtractor();
            Rows rows = this.executeQuery(service, query);
            ((TabmanResultSetExtractor)resultSetExtractor).processRows(rows);
            SdmxDataWriter dataRetrieval = new SdmxDataWriter(dataQuery);
            dataRetrieval.setDataWriter(dataWriter);
            dataRetrieval.writeData(resultSetExtractor.getSeriesList());
        }
        catch (SDMXDataException e) {
            this.logger.debug(e.getSDMXMessage(), (Throwable)e);
            FooterMessageImpl noDataMessage = new FooterMessageImpl(e.getCode(), e.getSeverity(), (TextTypeWrapper)new TextTypeWrapperImpl("en", e.getSDMXMessage(), null));
            dataWriter.close(new DataWriterEngine.FooterMessage[]{noDataMessage});
        }
        catch (Exception e) {
            this.logger.error("Unable to get the data", (Throwable)e);
            FooterMessageImpl noDataMessage = new FooterMessageImpl("500", DataWriterEngine.FooterMessage.SEVERITY.ERROR, (TextTypeWrapper)new TextTypeWrapperImpl("en", "Internal error", null));
            dataWriter.close(new DataWriterEngine.FooterMessage[]{noDataMessage});
        }
    }

    private Rows executeQuery(TabularDataService service, TabmanQuery query) throws Exception {
        this.logger.debug("Executing query");
        String jsonResponse = service.queryAsJson(query.getTableId(), null, query.getQueryFilter(), query.getQueryOrder(), query.getRequestedColumnsFilter());
        this.logger.debug("Query executed");
        this.logger.debug("JSON response " + jsonResponse);
        Rows response = new Rows(query.getRequestedColumns());
        response.fromJson(jsonResponse.getBytes());
        this.logger.debug("Bean created");
        return response;
    }
}

