/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.publishing.gis.publisher.csquare;

import gr.uoa.di.madgik.grs.record.GenericRecord;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.data.publishing.gis.publisher.common.Utils;
import org.gcube.data.publishing.gis.publisher.csquare.CSQuarePolygonDBDescriptor;
import org.gcube.data.publishing.gis.publisher.csquare.CSquarePolygonsDBInterface;
import org.gcube.data.publishing.gis.publisher.csquare.SQLType;
import org.gcube.data.publishing.gis.publisher.csquare.Table;
import org.gcube.data.publishing.gis.publisher.csquare.WorldTable;
import org.gcube.data.publishing.gis.publisher.plugin.fwk.model.CSquarePoint;
import org.gcube.data.publishing.gis.publisher.plugin.fwk.model.GeometryPoint;
import org.gcube.data.publishing.gis.publisher.plugin.fwk.utils.ResultGenerator;
import org.gcube.data.publishing.gis.publisher.plugin.fwk.writers.rswrapper.ResultWrapper;
import org.gcube.data.streams.Stream;
import org.gcube.data.streams.dsl.Streams;
import org.gcube.data.streams.generators.Generator;
import org.postgis.PGgeometry;
import org.postgresql.PGConnection;

public class CSquarePolygonDBImpl
implements CSquarePolygonsDBInterface {
    private static final Character CSV_DELIMITER = Character.valueOf(',');
    private static final String csquareCodeField = "csquarecode";
    private static final String GEOM_FIELD = "the_geom";
    private static final GCUBELog logger = new GCUBELog(CSquarePolygonDBImpl.class);
    private Connection connection = null;
    private CSQuarePolygonDBDescriptor dbDesc;
    private AtomicInteger openedResultSets = new AtomicInteger(0);

    public CSquarePolygonDBImpl(CSQuarePolygonDBDescriptor desc) {
        this.dbDesc = desc;
    }

    @Override
    public Table streamToTable(Stream<CSquarePoint> points) throws SQLException {
        Table toReturn = null;
        PreparedStatement ps = null;
        long count = 0L;
        while (points.hasNext()) {
            CSquarePoint point = (CSquarePoint)points.next();
            if (toReturn == null) {
                toReturn = this.createTableFromPoint(point);
                ps = this.prepareStatement(toReturn, point);
            }
            if (this.insertPoint(ps, point) == 0) {
                logger.warn((Object)("Unable to insert point into table " + toReturn.getTableName()));
                continue;
            }
            ++count;
        }
        toReturn.setRowCount(count);
        return toReturn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Table joinToWorld(Table toJoin) throws SQLException {
        WorldTable world = this.dbDesc.getWorldTables().get(0);
        String newTableName = "t" + Utils.getUUID();
        String joinQuery = "CREATE TABLE " + newTableName + " AS ( " + CSquarePolygonDBImpl.getJoinQuery(world, toJoin) + " )";
        logger.debug((Object)("Gonna execute join query : " + joinQuery));
        try (Statement stmt = null;){
            stmt = this.connection.createStatement();
            stmt.execute(joinQuery);
            long actualCount = CSquarePolygonDBImpl.getTableCount(newTableName, this.connection);
            if (toJoin.getRowCount() != actualCount) {
                logger.warn((Object)("JOINED TABLE " + newTableName + " has unexpected row count " + actualCount + " (exp. " + toJoin.getRowCount() + ")"));
            }
            Table table = new Table(actualCount, CSquarePolygonDBImpl.getTableFields(newTableName, this.connection), newTableName);
            return table;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public File exportCSV(Table toExport) throws IOException, SQLException {
        try (Statement stmt = null;){
            File out = File.createTempFile("csquare", ".csv");
            stmt = this.connection.createStatement(1004, 1007);
            logger.debug((Object)("Gonna exporting to  : " + out.getAbsolutePath()));
            long count = Utils.resultSetToCSVFile(stmt.executeQuery("SELECT * FROM " + toExport.getTableName()), out.getAbsolutePath(), true);
            if (count != toExport.getRowCount()) {
                logger.warn((Object)("Exported " + count + " out of " + toExport.getRowCount()));
            }
            File file = out;
            return file;
        }
    }

    private Connection getConnection() throws SQLException, ClassNotFoundException {
        Connection toReturn = DriverManager.getConnection(this.dbDesc.getEndpoint(), this.dbDesc.getUser(), this.dbDesc.getPassword());
        toReturn.setAutoCommit(false);
        ((PGConnection)toReturn).addDataType("geometry", Class.forName("org.postgis.PGgeometry"));
        return toReturn;
    }

    @Override
    public void openSession() throws SQLException, ClassNotFoundException {
        this.closeSession();
        this.connection = this.getConnection();
    }

    @Override
    public synchronized void closeSession() throws SQLException {
        if (this.connection != null) {
            Thread t = new Thread(){

                @Override
                public void run() {
                    int i = 0;
                    while ((i = CSquarePolygonDBImpl.this.openedResultSets.get()) > 0) {
                        logger.trace((Object)("Opened ResultSet count " + i));
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException e) {}
                    }
                    logger.trace((Object)"All ResultSet closed, closing connection");
                    try {
                        CSquarePolygonDBImpl.this.connection.close();
                    }
                    catch (SQLException e) {
                        logger.warn((Object)"Unable to close connection ", (Throwable)e);
                    }
                }
            };
            t.setName("CSQ_CONN_" + t.getName());
            t.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Table createTableFromPoint(CSquarePoint point) throws SQLException {
        String toCreateTable = "t" + Utils.getUUID();
        StringBuilder createQuery = new StringBuilder("CREATE TABLE " + toCreateTable + " ( " + csquareCodeField + " VARCHAR PRIMARY KEY,");
        for (Map.Entry field : point.getAttributes().entrySet()) {
            createQuery.append(" " + (String)field.getKey() + " " + CSquarePolygonDBImpl.getTypeDefinition(CSquarePolygonDBImpl.getSQLType(field.getValue())) + ",");
        }
        createQuery.deleteCharAt(createQuery.lastIndexOf(","));
        createQuery.append(")");
        String query = createQuery.toString();
        try (Statement stmt = null;){
            stmt = this.connection.createStatement();
            logger.debug((Object)("Goin to execute " + query));
            stmt.execute(query);
            Table table = new Table(0L, CSquarePolygonDBImpl.getSQLTypeByPoint(point), toCreateTable);
            return table;
        }
    }

    private PreparedStatement prepareStatement(Table theTable, CSquarePoint point) throws SQLException {
        StringBuilder fieldsName = new StringBuilder("(csquarecode,");
        StringBuilder fieldsValues = new StringBuilder("(?,");
        for (String f : point.getAttributes().keySet()) {
            fieldsValues.append("?,");
            fieldsName.append(f + ",");
        }
        fieldsValues.deleteCharAt(fieldsValues.length() - 1);
        fieldsValues.append(")");
        fieldsName.deleteCharAt(fieldsName.length() - 1);
        fieldsName.append(")");
        String query = "INSERT INTO " + theTable.getTableName() + " " + fieldsName + " VALUES " + fieldsValues;
        logger.debug((Object)("the prepared statement is :" + query));
        PreparedStatement ps = this.connection.prepareStatement(query, 2);
        return ps;
    }

    private int insertPoint(PreparedStatement ps, CSquarePoint point) throws SQLException {
        ps.setString(1, point.getcSquareCode());
        Serializable[] values = point.getAttributes().values().toArray(new Serializable[point.getAttributes().size()]);
        for (int i = 0; i < values.length; ++i) {
            ps.setObject(i + 2, values[i]);
        }
        return ps.executeUpdate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final long getTableCount(String table, Connection conn) throws SQLException {
        try (Statement stmt = null;){
            stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery("SELECT COUNT(*) FROM " + table);
            rs.next();
            long l = rs.getLong(1);
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final HashMap<String, SQLType> getTableFields(String table, Connection conn) throws SQLException {
        try (Statement stmt = null;){
            stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery("SELECT * FROM " + table + " LIMIT 1 OFFSET 0");
            rs.next();
            ResultSetMetaData meta = rs.getMetaData();
            HashMap<String, SQLType> toReturn = new HashMap<String, SQLType>();
            for (int i = 1; i <= meta.getColumnCount(); ++i) {
                toReturn.put(meta.getColumnName(i), CSquarePolygonDBImpl.getSQLType(rs.getObject(i)));
            }
            HashMap<String, SQLType> hashMap = toReturn;
            return hashMap;
        }
    }

    private static final HashMap<String, SQLType> getSQLTypeByPoint(CSquarePoint point) {
        HashMap<String, SQLType> toReturn = new HashMap<String, SQLType>();
        toReturn.put(csquareCodeField, SQLType.STRING);
        for (Map.Entry entry : point.getAttributes().entrySet()) {
            toReturn.put(((String)entry.getKey()).toLowerCase(), CSquarePolygonDBImpl.getSQLType(entry.getValue()));
        }
        return toReturn;
    }

    private static final String getJoinQuery(WorldTable world, Table t) {
        StringBuilder toReturn = new StringBuilder("SELECT T.*,");
        for (Map.Entry<String, SQLType> worldField : world.getFields().entrySet()) {
            if (t.getFields().containsKey(worldField.getKey()) || worldField.getKey().equalsIgnoreCase(csquareCodeField)) continue;
            toReturn.append(" W." + worldField.getKey() + ",");
        }
        toReturn.deleteCharAt(toReturn.lastIndexOf(","));
        toReturn.append(" FROM " + t.getTableName() + " AS T INNER JOIN " + world.getTableName() + " AS W ");
        toReturn.append(" ON T.csquarecode = W.csquarecode");
        return toReturn.toString();
    }

    @Override
    public Stream<GeometryPoint> streamTableRows(final Table toStreamTable, GCUBEScope scope) throws Exception {
        final ResultWrapper rs = new ResultWrapper(scope);
        final Statement stmt = this.connection.createStatement(1004, 1007);
        this.openedResultSets.incrementAndGet();
        final ResultSet rSql = stmt.executeQuery("SELECT * FROM " + toStreamTable.getTableName());
        Thread t = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    logger.debug((Object)("Streaming geometries from table " + toStreamTable.getTableName()));
                    ResultSetMetaData rsMeta = rSql.getMetaData();
                    long count = 0L;
                    long rowCount = 0L;
                    while (rSql.next()) {
                        ++rowCount;
                        try {
                            GeometryPoint point = new GeometryPoint();
                            for (int i = 1; i <= rsMeta.getColumnCount(); ++i) {
                                String colName = rsMeta.getColumnName(i);
                                if (colName.equalsIgnoreCase(CSquarePolygonDBImpl.GEOM_FIELD)) {
                                    point.setTheGeometry((PGgeometry)rSql.getObject(i));
                                    continue;
                                }
                                point.getAttributes().put(colName, (Serializable)rSql.getObject(i));
                            }
                            rs.add((Object)point);
                            ++count;
                        }
                        catch (Throwable t) {
                            logger.warn((Object)"Unable to stream object", t);
                        }
                    }
                    logger.debug((Object)("Streamed " + count + " geometries out of " + rowCount + " rows "));
                }
                catch (Throwable t) {
                    logger.error((Object)"Unable to stream data", t);
                }
                finally {
                    try {
                        rs.close();
                    }
                    catch (Exception e) {
                        logger.error((Object)"Cannot close Result wrapper ", (Throwable)e);
                    }
                    try {
                        rSql.close();
                        stmt.close();
                    }
                    catch (SQLException e) {
                        logger.error((Object)"Cannot close ResultSet", (Throwable)e);
                    }
                    logger.debug((Object)("Closing rs, ramaining count " + CSquarePolygonDBImpl.this.openedResultSets.decrementAndGet()));
                }
            }
        };
        t.setName("STREAMER" + t.getId());
        t.start();
        return Streams.pipe((Stream)Streams.convert((URI)new URI(rs.getLocator())).of(GenericRecord.class).withDefaults()).through((Generator)new ResultGenerator());
    }

    private static SQLType getSQLType(Object obj) {
        if (obj.getClass().isAssignableFrom(Integer.class)) {
            return SQLType.INTEGER;
        }
        if (obj.getClass().isAssignableFrom(Long.class)) {
            return SQLType.LONG;
        }
        if (obj.getClass().isAssignableFrom(Float.class)) {
            return SQLType.INTEGER;
        }
        if (obj.getClass().isAssignableFrom(Date.class) || obj.getClass().isAssignableFrom(java.util.Date.class)) {
            return SQLType.DATE;
        }
        if (obj.getClass().isAssignableFrom(Time.class)) {
            return SQLType.TIME;
        }
        if (obj.getClass().isAssignableFrom(Timestamp.class)) {
            return SQLType.TIMESTAMP;
        }
        if (obj.getClass().isAssignableFrom(Boolean.class)) {
            return SQLType.BOOLEAN;
        }
        if (obj.getClass().isAssignableFrom(PGgeometry.class)) {
            return SQLType.GEOMETRY;
        }
        return SQLType.TEXT;
    }

    private static int getType(SQLType type) {
        switch (type) {
            case BOOLEAN: {
                return 16;
            }
            case DATE: {
                return 91;
            }
            case FLOAT: {
                return 3;
            }
            case GEOMETRY: {
                return 1111;
            }
            case INTEGER: {
                return 4;
            }
            case LONG: {
                return -5;
            }
            case STRING: {
                return 12;
            }
            case TEXT: {
                return -16;
            }
            case TIME: {
                return 92;
            }
            case TIMESTAMP: {
                return 93;
            }
            case SERIAL: {
                return -5;
            }
        }
        return 0;
    }

    private static String getTypeDefinition(SQLType type) {
        switch (type) {
            case BOOLEAN: {
                return "boolean";
            }
            case DATE: {
                return "date";
            }
            case FLOAT: {
                return "decimal";
            }
            case GEOMETRY: {
                return "geometry";
            }
            case INTEGER: {
                return "integer";
            }
            case LONG: {
                return "bigint";
            }
            case STRING: {
                return "varchar (200)";
            }
            case TEXT: {
                return "text";
            }
            case TIME: {
                return "time";
            }
            case TIMESTAMP: {
                return "timestamp";
            }
            case SERIAL: {
                return "serial";
            }
        }
        return "";
    }
}

