/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.publishing.gis.publisher;

import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.informationsystem.ISException;
import org.gcube.common.core.informationsystem.client.AtomicCondition;
import org.gcube.common.core.informationsystem.client.ISClient;
import org.gcube.common.core.informationsystem.client.ISQuery;
import org.gcube.common.core.informationsystem.client.queries.GCUBERuntimeResourceQuery;
import org.gcube.common.core.resources.GCUBERuntimeResource;
import org.gcube.common.core.resources.runtime.AccessPoint;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.data.publishing.gis.publisher.csquare.CSQuarePolygonDBDescriptor;
import org.gcube.data.publishing.gis.publisher.csquare.CSquareConverterImpl;
import org.gcube.data.publishing.gis.publisher.csquare.SQLType;
import org.gcube.data.publishing.gis.publisher.csquare.WorldTable;
import org.gcube.data.publishing.gis.publisher.plugin.fwk.CSquareConverter;
import org.gcube.data.publishing.gis.publisher.plugin.fwk.GISInteractionFactory;
import org.gcube.data.publishing.gis.publisher.plugin.fwk.model.faults.RepositoryTypeNotSupportedException;
import org.gcube.data.publishing.gis.publisher.plugin.fwk.model.types.GISDataType;
import org.gcube.data.publishing.gis.publisher.plugin.fwk.model.types.GISRepositoryType;
import org.gcube.data.publishing.gis.publisher.plugins.InteractionWrapper;

public class PluginManager {
    private static ServiceLoader<GISInteractionFactory> loader = null;
    private static final GCUBELog logger = new GCUBELog(PluginManager.class);
    protected static ISClient isClient;
    private static ConcurrentHashMap<GCUBEScope, PluginManager> instancesMap;
    private GCUBEScope scope = null;
    private EnumMap<GISRepositoryType, GISInteractionFactory> pluginMap = new EnumMap(GISRepositoryType.class);
    private CSQuarePolygonDBDescriptor csquareDB = null;

    public static synchronized PluginManager get(GCUBEScope scope) {
        if (!instancesMap.containsKey(scope)) {
            PluginManager toInit = new PluginManager(scope);
            toInit.init();
            instancesMap.put(scope, toInit);
        }
        return instancesMap.get(scope);
    }

    private PluginManager(GCUBEScope scope) {
        this.scope = scope;
    }

    public GCUBEScope getScope() {
        return this.scope;
    }

    private void init() {
        logger.trace((Object)("checking plugin availability under scope " + this.scope));
        for (GISInteractionFactory factory : loader) {
            logger.trace((Object)("Initializing " + factory.getHandledRepositoryType() + " interaction factory"));
            if (factory.init(this.scope)) {
                this.pluginMap.put(factory.getHandledRepositoryType(), factory);
                continue;
            }
            logger.warn((Object)"Factory not initialized");
        }
        try {
            this.csquareDB = PluginManager.getCSquareDBInScope(this.scope);
            logger.trace((Object)("CSQUARE DB IS " + this.csquareDB));
        }
        catch (Exception e) {
            logger.warn((Object)"Unable to locate Csquare DB", (Throwable)e);
        }
    }

    public InteractionWrapper getInteractionPlugin(GISRepositoryType type) throws Exception {
        CSquareConverterImpl converter = null;
        if (this.csquareDB == null) {
            try {
                this.csquareDB = PluginManager.getCSquareDBInScope(this.scope);
                logger.trace((Object)("CSQUARE DB IS " + this.csquareDB));
            }
            catch (Exception e) {
                logger.warn((Object)"Unable to locate Csquare DB", (Throwable)e);
            }
        }
        converter = new CSquareConverterImpl(this.csquareDB, this.scope);
        if (this.pluginMap.containsKey(type)) {
            return new InteractionWrapper(this.pluginMap.get(type).createInteraction((CSquareConverter)converter));
        }
        throw new RepositoryTypeNotSupportedException("Type [" + type + "] not found under scope " + this.scope);
    }

    public Set<GISRepositoryType> getHandledRepositories() {
        return this.pluginMap.keySet();
    }

    public List<GISDataType> getHandledDataType(GISRepositoryType repoType) {
        return this.pluginMap.get(repoType).getHandledDataType();
    }

    private static CSQuarePolygonDBDescriptor getCSquareDBInScope(GCUBEScope scope) throws InstantiationException, IllegalAccessException, ISClient.ISMalformedQueryException, ISException {
        GCUBERuntimeResourceQuery runtimeQuery = (GCUBERuntimeResourceQuery)isClient.getQuery(GCUBERuntimeResourceQuery.class);
        runtimeQuery.addAtomicConditions(new AtomicCondition[]{new AtomicCondition("//Profile/Category", "Database")});
        runtimeQuery.addAtomicConditions(new AtomicCondition[]{new AtomicCondition("//Profile/Platform/Name", "postgis")});
        runtimeQuery.addAtomicConditions(new AtomicCondition[]{new AtomicCondition("//Profile/Name", "Geoserver database ")});
        List list = isClient.execute((ISQuery)runtimeQuery, scope);
        for (GCUBERuntimeResource rr : list) {
            Iterator i$ = rr.getAccessPoints().iterator();
            if (!i$.hasNext()) continue;
            AccessPoint access = (AccessPoint)i$.next();
            CSQuarePolygonDBDescriptor toReturn = new CSQuarePolygonDBDescriptor("jdbc:postgresql:" + access.getEndpoint(), access.getUsername(), access.getPassword());
            HashMap<String, SQLType> fields = new HashMap<String, SQLType>();
            fields.put("gid", SQLType.SERIAL);
            fields.put("csquarecode", SQLType.STRING);
            fields.put("the_geom", SQLType.GEOMETRY);
            toReturn.getWorldTables().add(new WorldTable(0L, fields, "world", 0.5));
            return toReturn;
        }
        return null;
    }

    static {
        loader = ServiceLoader.load(GISInteractionFactory.class);
        try {
            isClient = (ISClient)GHNContext.getImplementation(ISClient.class);
        }
        catch (Exception e) {
            logger.fatal((Object)"", (Throwable)e);
        }
        instancesMap = new ConcurrentHashMap();
    }
}

