package org.gcube.data.publishing.gis.publisher.model;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

import org.postgis.PGgeometry;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;

@XStreamAlias("GeometryPoint")
public class GeometryPoint implements GeoPoint {
	
	@XStreamAsAttribute
	private PGgeometry theGeometry;	
	private Map<String,Serializable> attributes=new HashMap<String, Serializable>();
	
	public GeometryPoint() {
		// TODO Auto-generated constructor stub
	}

	public GeometryPoint(PGgeometry theGeometry,
			Map<String, Serializable> attributes) {
		super();
		this.theGeometry = theGeometry;
		this.attributes = attributes;
	}

	/**
	 * @return the theGeometry
	 */
	public PGgeometry getTheGeometry() {
		return theGeometry;
	}

	/**
	 * @param theGeometry the theGeometry to set
	 */
	public void setTheGeometry(PGgeometry theGeometry) {
		this.theGeometry = theGeometry;
	}

	/**
	 * @return the attributes
	 */
	public Map<String, Serializable> getAttributes() {
		return attributes;
	}

	/**
	 * @param attributes the attributes to set
	 */
	public void setAttributes(Map<String, Serializable> attributes) {
		this.attributes = attributes;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("GeometryPoint [theGeometry=");
		builder.append(theGeometry);
		builder.append(", attributes=");
		builder.append(attributes);
		builder.append("]");
		return builder.toString();
	}
	
	
	
	
}
