package org.gcube.data.publishing.gis.publisher.model.requests;

import java.util.ArrayList;
import java.util.List;

import org.gcube.data.publishing.gis.publisher.model.types.GISRepositoryType;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import com.thoughtworks.xstream.annotations.XStreamImplicitCollection;

@XStreamAlias("GISRequestConfiguration")
public class GISRequestConfiguration {
	
	@XStreamAsAttribute
	private boolean pushInformationInGEONetwork=true;
	@XStreamAsAttribute
	private String workspace;
	@XStreamAsAttribute
	private GISRepositoryType repositoryDestination=GISRepositoryType.GEOSERVER;
	
	@XStreamImplicit
	private List<LayerGenerationRequest> toGenerateLayers=new ArrayList<LayerGenerationRequest>();
	@XStreamImplicit
	private List<StyleGenerationRequest> toGenerateStyles=new ArrayList<StyleGenerationRequest>();
	@XStreamImplicit
	private List<WMSGroupGenerationRequest> toGenerateWMSGroups=new ArrayList<WMSGroupGenerationRequest>();
	
	
	
	public GISRequestConfiguration() {
		// TODO Auto-generated constructor stub
	}



	/**
	 * @return the pushInformationInGEONetwork
	 */
	public boolean isPushInformationInGEONetwork() {
		return pushInformationInGEONetwork;
	}



	/**
	 * @param pushInformationInGEONetwork the pushInformationInGEONetwork to set
	 */
	public void setPushInformationInGEONetwork(boolean pushInformationInGEONetwork) {
		this.pushInformationInGEONetwork = pushInformationInGEONetwork;
	}



	/**
	 * @return the workspace
	 */
	public String getWorkspace() {
		return workspace;
	}



	/**
	 * @param workspace the workspace to set
	 */
	public void setWorkspace(String workspace) {
		this.workspace = workspace;
	}



	/**
	 * @return the repositoryDestination
	 */
	public GISRepositoryType getRepositoryDestination() {
		return repositoryDestination;
	}



	/**
	 * @param repositoryDestination the repositoryDestination to set
	 */
	public void setRepositoryDestination(GISRepositoryType repositoryDestination) {
		this.repositoryDestination = repositoryDestination;
	}



	/**
	 * @return the toGenerateLayers
	 */
	public List<LayerGenerationRequest> getToGenerateLayers() {
		return toGenerateLayers;
	}



	/**
	 * @param toGenerateLayers the toGenerateLayers to set
	 */
	public void setToGenerateLayers(List<LayerGenerationRequest> toGenerateLayers) {
		this.toGenerateLayers = toGenerateLayers;
	}



	/**
	 * @return the toGenerateStyles
	 */
	public List<StyleGenerationRequest> getToGenerateStyles() {
		return toGenerateStyles;
	}



	/**
	 * @param toGenerateStyles the toGenerateStyles to set
	 */
	public void setToGenerateStyles(List<StyleGenerationRequest> toGenerateStyles) {
		this.toGenerateStyles = toGenerateStyles;
	}



	/**
	 * @return the toGenerateWMSGroups
	 */
	public List<WMSGroupGenerationRequest> getToGenerateWMSGroups() {
		return toGenerateWMSGroups;
	}



	/**
	 * @param toGenerateWMSGroups the toGenerateWMSGroups to set
	 */
	public void setToGenerateWMSGroups(
			List<WMSGroupGenerationRequest> toGenerateWMSGroups) {
		this.toGenerateWMSGroups = toGenerateWMSGroups;
	}



	/* (non-Javadoc)
	 * @see java.lang.Object#hashCode()
	 */
	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + (pushInformationInGEONetwork ? 1231 : 1237);
		result = prime
				* result
				+ ((repositoryDestination == null) ? 0 : repositoryDestination
						.hashCode());
		result = prime
				* result
				+ ((toGenerateLayers == null) ? 0 : toGenerateLayers.hashCode());
		result = prime
				* result
				+ ((toGenerateStyles == null) ? 0 : toGenerateStyles.hashCode());
		result = prime
				* result
				+ ((toGenerateWMSGroups == null) ? 0 : toGenerateWMSGroups
						.hashCode());
		result = prime * result
				+ ((workspace == null) ? 0 : workspace.hashCode());
		return result;
	}



	/* (non-Javadoc)
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		GISRequestConfiguration other = (GISRequestConfiguration) obj;
		if (pushInformationInGEONetwork != other.pushInformationInGEONetwork)
			return false;
		if (repositoryDestination != other.repositoryDestination)
			return false;
		if (toGenerateLayers == null) {
			if (other.toGenerateLayers != null)
				return false;
		} else if (!toGenerateLayers.equals(other.toGenerateLayers))
			return false;
		if (toGenerateStyles == null) {
			if (other.toGenerateStyles != null)
				return false;
		} else if (!toGenerateStyles.equals(other.toGenerateStyles))
			return false;
		if (toGenerateWMSGroups == null) {
			if (other.toGenerateWMSGroups != null)
				return false;
		} else if (!toGenerateWMSGroups.equals(other.toGenerateWMSGroups))
			return false;
		if (workspace == null) {
			if (other.workspace != null)
				return false;
		} else if (!workspace.equals(other.workspace))
			return false;
		return true;
	}



	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("GISRequestConfiguration [pushInformationInGEONetwork=");
		builder.append(pushInformationInGEONetwork);
		builder.append(", workspace=");
		builder.append(workspace);
		builder.append(", repositoryDestination=");
		builder.append(repositoryDestination);
		builder.append(", toGenerateLayers=");
		builder.append(toGenerateLayers);
		builder.append(", toGenerateStyles=");
		builder.append(toGenerateStyles);
		builder.append(", toGenerateWMSGroups=");
		builder.append(toGenerateWMSGroups);
		builder.append("]");
		return builder.toString();
	}

	

		
	
}
