package org.gcube.data.publishing.gis.publisher.client.plugins;

import org.gcube.common.clients.gcore.builders.StatelessBuilder;
import org.gcube.common.clients.gcore.builders.StatelessBuilderImpl;
import org.gcube.common.clients.gcore.plugins.Plugin;
import org.gcube.data.gis.publisher.stubs.PublisherPortType;
import org.gcube.data.publishing.gis.publisher.client.Constants;
import org.gcube.data.publishing.gis.publisher.client.proxies.Publisher;

public abstract class AbstractPlugin<S,P> implements Plugin<S,P> {

	private static final PublisherPlugin publisher_plugin=new PublisherPlugin();
	
	public static StatelessBuilder<Publisher> publisher(){
		return new StatelessBuilderImpl<PublisherPortType, Publisher>(publisher_plugin);
	}
	
	public final String name;
	
	public AbstractPlugin(String name) {
		this.name=name;
	}
	
	@Override
	public String serviceClass() {
		return Constants.SERVICE_CLASS;
	}
	
	@Override
	public String serviceName() {
		return Constants.SERVICE_NAME;
	}
	
	@Override
	public String namespace() {
		return Constants.NAMESPACE;
	}
	
	@Override
	public String name() {
		return name;
	}
}
