package org.gcube.data.publishing.ckan2zenodo.model;

import java.io.File;

import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

@Getter
@Setter
@AllArgsConstructor
@ToString
public class DownloadedFile {

	private CkanResource source;
	private File f;
	private String MD5;
	private String remoteFileName;


	public String getToUseFileName(){
		if (getExtension(source.getName())!=null){
			// source contains extension
			return source.getName();
		}else {
			String evaluatedExtension=getExtension(remoteFileName);
			if(evaluatedExtension!=null)
				return source.getName()+evaluatedExtension;
			else return source.getName(); // No extension
		}
	}

	static final String getExtension(String filename){
			int lastIndexOf = filename.lastIndexOf(".");
			if (lastIndexOf == -1) {
				return null; // no extension
			}
			return filename.substring(lastIndexOf);
	}
}
