/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.publishing.ckan2zenodo.clients;

import java.beans.ConstructorProperties;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.Response;
import org.gcube.common.authorization.client.Constants;
import org.gcube.common.authorization.library.AuthorizationEntry;
import org.gcube.common.authorization.library.provider.SecurityTokenProvider;
import org.gcube.common.resources.gcore.ServiceEndpoint;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.data.publishing.ckan2zenodo.model.CkanItemDescriptor;
import org.gcube.data.publishing.ckan2zenodo.model.faults.GcatException;
import org.gcube.gcat.client.Item;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.impl.XQuery;
import org.gcube.resources.discovery.icclient.ICFactory;
import org.glassfish.jersey.media.multipart.MultiPartFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GCat {
    private static final Logger log = LoggerFactory.getLogger(GCat.class);

    public static CkanItemDescriptor getByID(String itemName) throws MalformedURLException, GcatException {
        CkanItemDescriptor toReturn = new CkanItemDescriptor(new Item().read(itemName));
        try {
            String itemUrl = toReturn.getItemUrl();
            new URL(itemUrl);
        }
        catch (Exception e) {
            log.debug("Invalid item url for item " + itemName + ". Retrieving it.. ");
            String itemUrl = GCat.getItemUrl(toReturn);
            log.warn("Setting following item URL " + itemUrl + " on item " + toReturn.getName());
            toReturn.setItemUrl(itemUrl);
            GCat.updateItem(toReturn);
        }
        return toReturn;
    }

    public static void updateItem(CkanItemDescriptor toUpdate) throws MalformedURLException {
        new Item().update(toUpdate.getName(), toUpdate.getContent());
    }

    public static void check() throws MalformedURLException {
        new Item().count();
    }

    private static String getItemUrl(CkanItemDescriptor toUpdate) throws GcatException {
        try {
            String baseUrl = GCat.getResolverBaseUrl();
            log.debug("Resolver BaseUrl : " + baseUrl);
            ResolverRequest request = new ResolverRequest(GCat.getCurrentScope(), "dataset", toUpdate.getName());
            log.debug("Sending request : " + request);
            Client webClient = (Client)ClientBuilder.newClient().property("jersey.config.client.suppressHttpComplianceValidation", (Object)true);
            webClient.register(MultiPartFeature.class);
            Response resp = webClient.target(baseUrl).queryParam("gcube-token", new Object[]{SecurityTokenProvider.instance.get()}).request(new String[]{"text/plain"}).post(Entity.entity((Object)request, (String)"application/json"));
            if (resp.getStatus() < 200 || resp.getStatus() >= 300) {
                String remoteMessage = (String)resp.readEntity(String.class);
                Integer httpCode = resp.getStatus();
                GcatException e = new GcatException("Resolver Response [" + httpCode + "] : " + remoteMessage);
                throw e;
            }
            return (String)resp.readEntity(String.class);
        }
        catch (Exception e) {
            log.error("Unable to retrieve itemUrl", (Throwable)e);
            throw new GcatException("Unable to retrieve itemUrl", e);
        }
    }

    private static String getCurrentScope() {
        try {
            String token = SecurityTokenProvider.instance.get();
            log.debug("Token is : " + token);
            if (token == null) {
                throw new Exception("Security Token is null");
            }
            AuthorizationEntry entry = Constants.authorizationService().get(token);
            return entry.getContext();
        }
        catch (Exception e) {
            log.debug("Unable to resolve token, checking scope provider..", (Throwable)e);
            return ScopeProvider.instance.get();
        }
    }

    private static String getResolverBaseUrl() throws Exception {
        try {
            XQuery query = ICFactory.queryFor(ServiceEndpoint.class);
            query.addCondition("$resource/Profile/Name/text() eq 'HTTP-URI-Resolver'").setResult("$resource/Profile/AccessPoint");
            DiscoveryClient client = ICFactory.clientFor(ServiceEndpoint.AccessPoint.class);
            List endpoints = client.submit((Query)query);
            if (endpoints.size() == 0) {
                throw new Exception("No Resolver available");
            }
            HashMap<String, ServiceEndpoint.AccessPoint> mapEntryNameForAP = new HashMap<String, ServiceEndpoint.AccessPoint>(endpoints.size());
            for (ServiceEndpoint.AccessPoint accessPoint : endpoints) {
                mapEntryNameForAP.put(accessPoint.name(), accessPoint);
                Map propertyMap = accessPoint.propertyMap();
                if (propertyMap == null) continue;
                for (String key : propertyMap.keySet()) {
                    System.out.println("Property value: " + ((ServiceEndpoint.Property)propertyMap.get(key)).value());
                }
            }
            ServiceEndpoint.AccessPoint accessPoint = (ServiceEndpoint.AccessPoint)mapEntryNameForAP.get("ctlg");
            return accessPoint.address();
        }
        catch (Throwable t) {
            throw new Exception("Unable to retrieve resolver URL ", t);
        }
    }

    private static class ResolverRequest {
        private String gcube_scope;
        private String entity_context = "dataset";
        private String entity_name;

        @ConstructorProperties(value={"gcube_scope", "entity_context", "entity_name"})
        public ResolverRequest(String gcube_scope, String entity_context, String entity_name) {
            this.gcube_scope = gcube_scope;
            this.entity_context = entity_context;
            this.entity_name = entity_name;
        }

        public String getGcube_scope() {
            return this.gcube_scope;
        }

        public String getEntity_context() {
            return this.entity_context;
        }

        public String getEntity_name() {
            return this.entity_name;
        }

        public void setGcube_scope(String gcube_scope) {
            this.gcube_scope = gcube_scope;
        }

        public void setEntity_context(String entity_context) {
            this.entity_context = entity_context;
        }

        public void setEntity_name(String entity_name) {
            this.entity_name = entity_name;
        }

        public ResolverRequest() {
        }

        public String toString() {
            return "GCat.ResolverRequest(gcube_scope=" + this.getGcube_scope() + ", entity_context=" + this.getEntity_context() + ", entity_name=" + this.getEntity_name() + ")";
        }
    }
}

