/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.publishing.ckan2zenodo.model.zenodo;

import com.fasterxml.jackson.annotation.JsonFormat;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import org.gcube.data.publishing.ckan2zenodo.model.zenodo.DepositionLinks;
import org.gcube.data.publishing.ckan2zenodo.model.zenodo.DepositionMetadata;
import org.gcube.data.publishing.ckan2zenodo.model.zenodo.FileDeposition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZenodoDeposition {
    private static final Logger log = LoggerFactory.getLogger(ZenodoDeposition.class);
    @JsonFormat(pattern="yyyy-MM-dd'T'HH:mm:ss.SSSSSSZ")
    private Date created;
    private String doi;
    private DepositionLinks links;
    private ArrayList<FileDeposition> files;
    private Integer id;
    private DepositionMetadata metadata;
    @JsonFormat(pattern="yyyy-MM-dd'T'HH:mm:ss.SSSSSSZ")
    private Date modified;
    private Integer owner;
    private Integer record_id;
    private URL record_url;
    private String state;
    private Boolean submitted;
    private String title;

    public URL getDOIUrl() throws MalformedURLException {
        try {
            return new URL(this.links.getConceptdoi());
        }
        catch (Throwable t) {
            log.warn("Returned concept link is broken, forming it from doi..");
            return new URL("https://doi.org/" + this.doi);
        }
    }

    public Date getCreated() {
        return this.created;
    }

    public String getDoi() {
        return this.doi;
    }

    public DepositionLinks getLinks() {
        return this.links;
    }

    public ArrayList<FileDeposition> getFiles() {
        return this.files;
    }

    public Integer getId() {
        return this.id;
    }

    public DepositionMetadata getMetadata() {
        return this.metadata;
    }

    public Date getModified() {
        return this.modified;
    }

    public Integer getOwner() {
        return this.owner;
    }

    public Integer getRecord_id() {
        return this.record_id;
    }

    public URL getRecord_url() {
        return this.record_url;
    }

    public String getState() {
        return this.state;
    }

    public Boolean getSubmitted() {
        return this.submitted;
    }

    public String getTitle() {
        return this.title;
    }

    public void setCreated(Date created) {
        this.created = created;
    }

    public void setDoi(String doi) {
        this.doi = doi;
    }

    public void setLinks(DepositionLinks links) {
        this.links = links;
    }

    public void setFiles(ArrayList<FileDeposition> files) {
        this.files = files;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public void setMetadata(DepositionMetadata metadata) {
        this.metadata = metadata;
    }

    public void setModified(Date modified) {
        this.modified = modified;
    }

    public void setOwner(Integer owner) {
        this.owner = owner;
    }

    public void setRecord_id(Integer record_id) {
        this.record_id = record_id;
    }

    public void setRecord_url(URL record_url) {
        this.record_url = record_url;
    }

    public void setState(String state) {
        this.state = state;
    }

    public void setSubmitted(Boolean submitted) {
        this.submitted = submitted;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ZenodoDeposition)) {
            return false;
        }
        ZenodoDeposition other = (ZenodoDeposition)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Date this$created = this.getCreated();
        Date other$created = other.getCreated();
        if (this$created == null ? other$created != null : !((Object)this$created).equals(other$created)) {
            return false;
        }
        String this$doi = this.getDoi();
        String other$doi = other.getDoi();
        if (this$doi == null ? other$doi != null : !this$doi.equals(other$doi)) {
            return false;
        }
        DepositionLinks this$links = this.getLinks();
        DepositionLinks other$links = other.getLinks();
        if (this$links == null ? other$links != null : !this$links.equals(other$links)) {
            return false;
        }
        ArrayList<FileDeposition> this$files = this.getFiles();
        ArrayList<FileDeposition> other$files = other.getFiles();
        if (this$files == null ? other$files != null : !((Object)this$files).equals(other$files)) {
            return false;
        }
        Integer this$id = this.getId();
        Integer other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        DepositionMetadata this$metadata = this.getMetadata();
        DepositionMetadata other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        Date this$modified = this.getModified();
        Date other$modified = other.getModified();
        if (this$modified == null ? other$modified != null : !((Object)this$modified).equals(other$modified)) {
            return false;
        }
        Integer this$owner = this.getOwner();
        Integer other$owner = other.getOwner();
        if (this$owner == null ? other$owner != null : !((Object)this$owner).equals(other$owner)) {
            return false;
        }
        Integer this$record_id = this.getRecord_id();
        Integer other$record_id = other.getRecord_id();
        if (this$record_id == null ? other$record_id != null : !((Object)this$record_id).equals(other$record_id)) {
            return false;
        }
        URL this$record_url = this.getRecord_url();
        URL other$record_url = other.getRecord_url();
        if (this$record_url == null ? other$record_url != null : !((Object)this$record_url).equals(other$record_url)) {
            return false;
        }
        String this$state = this.getState();
        String other$state = other.getState();
        if (this$state == null ? other$state != null : !this$state.equals(other$state)) {
            return false;
        }
        Boolean this$submitted = this.getSubmitted();
        Boolean other$submitted = other.getSubmitted();
        if (this$submitted == null ? other$submitted != null : !((Object)this$submitted).equals(other$submitted)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        return !(this$title == null ? other$title != null : !this$title.equals(other$title));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ZenodoDeposition;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Date $created = this.getCreated();
        result = result * 59 + ($created == null ? 0 : ((Object)$created).hashCode());
        String $doi = this.getDoi();
        result = result * 59 + ($doi == null ? 0 : $doi.hashCode());
        DepositionLinks $links = this.getLinks();
        result = result * 59 + ($links == null ? 0 : $links.hashCode());
        ArrayList<FileDeposition> $files = this.getFiles();
        result = result * 59 + ($files == null ? 0 : ((Object)$files).hashCode());
        Integer $id = this.getId();
        result = result * 59 + ($id == null ? 0 : ((Object)$id).hashCode());
        DepositionMetadata $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 0 : ((Object)$metadata).hashCode());
        Date $modified = this.getModified();
        result = result * 59 + ($modified == null ? 0 : ((Object)$modified).hashCode());
        Integer $owner = this.getOwner();
        result = result * 59 + ($owner == null ? 0 : ((Object)$owner).hashCode());
        Integer $record_id = this.getRecord_id();
        result = result * 59 + ($record_id == null ? 0 : ((Object)$record_id).hashCode());
        URL $record_url = this.getRecord_url();
        result = result * 59 + ($record_url == null ? 0 : ((Object)$record_url).hashCode());
        String $state = this.getState();
        result = result * 59 + ($state == null ? 0 : $state.hashCode());
        Boolean $submitted = this.getSubmitted();
        result = result * 59 + ($submitted == null ? 0 : ((Object)$submitted).hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 0 : $title.hashCode());
        return result;
    }

    public String toString() {
        return "ZenodoDeposition(created=" + this.getCreated() + ", doi=" + this.getDoi() + ", links=" + this.getLinks() + ", files=" + this.getFiles() + ", id=" + this.getId() + ", metadata=" + this.getMetadata() + ", modified=" + this.getModified() + ", owner=" + this.getOwner() + ", record_id=" + this.getRecord_id() + ", record_url=" + this.getRecord_url() + ", state=" + this.getState() + ", submitted=" + this.getSubmitted() + ", title=" + this.getTitle() + ")";
    }
}

