/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.publishing.ckan2zenodo.clients;

import java.nio.file.Files;
import java.util.Collection;
import java.util.concurrent.Callable;
import org.gcube.data.publishing.ckan2zenodo.clients.Zenodo;
import org.gcube.data.publishing.ckan2zenodo.commons.Net;
import org.gcube.data.publishing.ckan2zenodo.model.CkanResource;
import org.gcube.data.publishing.ckan2zenodo.model.DownloadedFile;
import org.gcube.data.publishing.ckan2zenodo.model.zenodo.FileDeposition;
import org.gcube.data.publishing.ckan2zenodo.model.zenodo.ZenodoDeposition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UploadFilesCall
implements Callable<ZenodoDeposition> {
    private static final Logger log = LoggerFactory.getLogger(UploadFilesCall.class);
    private Collection<CkanResource> toUpload;
    private ZenodoDeposition deposition;
    private Zenodo z;

    public UploadFilesCall(Collection<CkanResource> toUpload, ZenodoDeposition deposition, Zenodo z) {
        this.toUpload = toUpload;
        this.deposition = deposition;
        this.z = z;
    }

    @Override
    public ZenodoDeposition call() throws Exception {
        ZenodoDeposition dep = this.deposition;
        log.debug("Starting file transfer for deposition " + this.deposition.getTitle() + " id : " + this.deposition.getId());
        log.debug("Removing not referenced files..");
        for (FileDeposition f : dep.getFiles()) {
            CkanResource found = null;
            for (CkanResource r : this.toUpload) {
                if (!r.getName().equals(f.getFilename())) continue;
                found = r;
                break;
            }
            if (found == null) {
                try {
                    log.debug("Remote file " + f + " is not in requested set. Deleting it..");
                    this.z.deleteFile(dep, f);
                    continue;
                }
                catch (Throwable t) {
                    throw new Exception("Unable to delete " + f, t);
                }
            }
            DownloadedFile downloaded = null;
            try {
                log.debug("Found already existing remote file " + f);
                downloaded = Net.download(found);
                if (downloaded.getMD5().equals(f.getChecksum())) continue;
                log.debug("MD5 differ, going to update : " + downloaded + " - " + f);
                this.z.deleteFile(dep, f);
                this.z.uploadFile(dep, found.getName(), downloaded.getF());
            }
            catch (Throwable t) {
                throw new Exception("Unable to update " + f, t);
            }
            finally {
                if (downloaded == null) continue;
                Files.deleteIfExists(downloaded.getF().toPath());
            }
        }
        log.debug("Going to push additional resources for " + this.deposition.getTitle() + " ID : " + this.deposition.getId());
        for (CkanResource r : this.toUpload) {
            DownloadedFile downloaded = null;
            try {
                boolean found = false;
                for (FileDeposition f : dep.getFiles()) {
                    if (!f.getFilename().equals(r.getName())) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                downloaded = Net.download(r);
                this.z.uploadFile(dep, r.getName(), downloaded.getF());
            }
            catch (Throwable t) {
                throw new Exception("Unable to upload " + r.getName() + ".", t);
            }
        }
        return this.z.readDeposition(dep.getId());
    }
}

