package org.gcube.data.publishing.ckan2zenodo;

import java.net.MalformedURLException;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Future;

import org.gcube.data.publishing.ckan2zenodo.clients.FileUploaderManager;
import org.gcube.data.publishing.ckan2zenodo.clients.GCat;
import org.gcube.data.publishing.ckan2zenodo.clients.UploadFilesCall;
import org.gcube.data.publishing.ckan2zenodo.clients.Zenodo;
import org.gcube.data.publishing.ckan2zenodo.model.CkanItemDescriptor;
import org.gcube.data.publishing.ckan2zenodo.model.CkanRelatedIdentifier;
import org.gcube.data.publishing.ckan2zenodo.model.CkanResource;
import org.gcube.data.publishing.ckan2zenodo.model.UploadPolicy;
import org.gcube.data.publishing.ckan2zenodo.model.faults.ConfigurationException;
import org.gcube.data.publishing.ckan2zenodo.model.faults.GcatException;
import org.gcube.data.publishing.ckan2zenodo.model.faults.InvalidItemException;
import org.gcube.data.publishing.ckan2zenodo.model.faults.TransformationException;
import org.gcube.data.publishing.ckan2zenodo.model.faults.ZenodoException;
import org.gcube.data.publishing.ckan2zenodo.model.zenodo.ZenodoDeposition;

import lombok.extern.slf4j.Slf4j;


@Slf4j
public class Ckan2ZenodoImpl implements Ckan2Zenodo{


	private Zenodo z=null;

	private synchronized Zenodo getZenodo() throws ConfigurationException {
		if(z==null)
			z=Zenodo.get();
		return z;
	}

	@Override
	public CkanItemDescriptor read(String itemName) throws GcatException {
		try{
			return GCat.getByID(itemName);
		}catch(Throwable e) {
			log.warn("Unable to load "+itemName+" from gCat",e);
			throw new GcatException("Unable to load item from gCat");
		}
	}

	@Override
	public ZenodoDeposition translate(CkanItemDescriptor desc) throws InvalidItemException, ZenodoException, ConfigurationException, TransformationException {
		ZenodoDeposition toUpdate=null;
		CkanRelatedIdentifier doi=desc.getZenodoDoi();
		if(doi!=null) {
			Zenodo z=getZenodo();
			toUpdate=z.readDeposition(doi.getZenodoId());			
		}
		Translator tr=new TransformerManager().getByProfile(desc.getProfile());
		return tr.transform(desc, toUpdate);
	}

	@Override
	public ZenodoDeposition updatedMetadata(ZenodoDeposition toUpdate) throws ZenodoException, ConfigurationException {
		Zenodo z=getZenodo();
		//initialize if not created
		if(toUpdate.getSubmitted()==null) {
			ZenodoDeposition created=z.createNew();
			created.setMetadata(toUpdate.getMetadata());
			toUpdate=created;
		}
		if(toUpdate.getSubmitted()&&toUpdate.getState().equals("done"))
			z.unlockPublished(toUpdate.getId());
	
		ZenodoDeposition updated=z.updateMetadata(toUpdate);
		if(toUpdate.getSubmitted())
			return z.publish(updated);
		else return updated;
		
	}

	@Override
	public List<CkanResource> filterResources(CkanItemDescriptor desc) throws ConfigurationException, TransformationException {
		Translator tr=new TransformerManager().getByProfile(desc.getProfile());
		return tr.filterResources(desc);
	}

	@Override
	public Future<ZenodoDeposition> uploadFiles(Set<CkanResource> toUpload, ZenodoDeposition deposition) throws ZenodoException, ConfigurationException {
		final Zenodo z=getZenodo();
		 
		UploadFilesCall call=new UploadFilesCall(toUpload,deposition,z);

		return FileUploaderManager.submitForDeposition(call);
		
	}

	

	@Override
	public ZenodoDeposition publish(ZenodoDeposition dep, CkanItemDescriptor toUpdate) throws ZenodoException, ConfigurationException, InvalidItemException, MalformedURLException {
		Zenodo z=getZenodo();
		if(dep.getSubmitted()&&dep.getState().equals("done"))
			z.unlockPublished(dep.getId());
		// Publishing to zenodo
		ZenodoDeposition toReturn =z.publish(dep);
		// Updateing item
		if(toUpdate.getZenodoDoi()==null) {
			toUpdate.setZenodoDoi(CkanRelatedIdentifier.getZenodo(toReturn.getDOIUrl()));
			GCat.updateItem(toUpdate);
		}
		return toReturn;
	}



}
