/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.publishing.ckan2zenodo;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalConfiguration {
    private static final Logger log = LoggerFactory.getLogger(LocalConfiguration.class);
    private static final Object $LOCK = new Object[0];
    public static final Map<String, Object> defaultConfigurationMap = new HashMap<String, Object>();
    private static LocalConfiguration instance;
    Properties props = new Properties();

    static {
        defaultConfigurationMap.put("THREAD_POOL_SIZE", "5");
        defaultConfigurationMap.put("ZENODO_ENDPOINT_CATEGORY", "Repository");
        defaultConfigurationMap.put("ZENODO_ENDPOINT_PLATFORM", "Zenodo");
        instance = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final LocalConfiguration get() {
        Object object = $LOCK;
        synchronized (object) {
            if (instance == null) {
                instance = new LocalConfiguration();
            }
            return instance;
        }
    }

    public static String getProperty(String property) {
        try {
            return (String)LocalConfiguration.get().props.getOrDefault((Object)property, defaultConfigurationMap.get(property));
        }
        catch (Throwable t) {
            log.warn("Unable to get configuration property " + property, t);
            return "" + defaultConfigurationMap.get(property);
        }
    }

    public Map<String, String> asMap() {
        HashMap<String, String> toReturn = new HashMap<String, String>();
        for (Object key : this.props.keySet()) {
            toReturn.put("" + key, (String)this.props.getOrDefault(key, defaultConfigurationMap.get(key)));
        }
        return toReturn;
    }

    private LocalConfiguration() {
        try {
            this.props.load(this.getClass().getResourceAsStream("/config.properties"));
        }
        catch (Exception e) {
            log.warn("********************** UNABLE TO LOAD PROPERTIES **********************", (Throwable)e);
            log.debug("Reverting to defaults : " + defaultConfigurationMap);
        }
    }

    public static class Configuration {
        public static final String THREAD_POOL_SIZE = "THREAD_POOL_SIZE";
        public static final String ZENODO_ENDPOINT_CATEGORY = "ZENODO_ENDPOINT_CATEGORY";
        public static final String ZENODO_ENDPOINT_PLATFORM = "ZENODO_ENDPOINT_PLATFORM";
    }
}

