/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.publishing.accounting.service;

import java.util.concurrent.TimeUnit;
import org.gcube.accounting.analytics.persistence.AccountingPersistenceBackendQueryConfiguration;
import org.gcube.accounting.analytics.persistence.couchbase.AccountingPersistenceQueryCouchBase;
import org.gcube.accounting.persistence.AccountingPersistence;
import org.gcube.accounting.persistence.AccountingPersistenceFactory;
import org.gcube.smartgears.ApplicationManager;
import org.gcube.smartgears.ContextProvider;
import org.gcube.smartgears.context.application.ApplicationContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccountingInitializer
implements ApplicationManager {
    private static Logger logger = LoggerFactory.getLogger(AccountingInitializer.class);
    ApplicationContext ctx = ContextProvider.get();
    private AccountingPersistence accountingPersistence = null;
    protected AccountingPersistenceQueryCouchBase accountingPersistenceAnalytics;

    public void onInit() {
        logger.info("AccountingInitializer on init");
        this.accountingPersistence = AccountingPersistenceFactory.getPersistence();
        try {
            this.accountingPersistence.flush(1L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            logger.error("AccountingInitializer onInit error:", (Throwable)e);
            e.printStackTrace();
        }
        try {
            AccountingPersistenceBackendQueryConfiguration configuration = new AccountingPersistenceBackendQueryConfiguration(AccountingPersistenceQueryCouchBase.class);
            this.accountingPersistenceAnalytics = new AccountingPersistenceQueryCouchBase();
            this.accountingPersistenceAnalytics.prepareConnection(configuration);
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
    }

    public void onShutdown() {
        logger.info("AccountingInitializer onShutdown");
        try {
            this.accountingPersistence.flush(1L, TimeUnit.SECONDS);
            this.accountingPersistence.close();
            this.accountingPersistenceAnalytics.close();
        }
        catch (Exception e) {
            logger.error("AccountingInitializer shutdown error:", (Throwable)e);
            e.printStackTrace();
        }
    }

    public AccountingPersistence getAccountingPersistence() {
        return this.accountingPersistence;
    }

    public AccountingPersistenceQueryCouchBase getAccountingPersistenceQuery() {
        return this.accountingPersistenceAnalytics;
    }
}

