/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.oai.tmplugin.repository;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.gcube.common.Harvester;
import org.gcube.common.data.Record;
import org.gcube.common.data.RecordIterator;
import org.gcube.common.repository.Identify;
import org.gcube.data.oai.tmplugin.binders.OAIDCBinder;
import org.gcube.data.oai.tmplugin.repository.Repository;
import org.gcube.data.oai.tmplugin.repository.Set;
import org.gcube.data.oai.tmplugin.repository.Summary;
import org.gcube.data.oai.tmplugin.repository.iterators.RecordIter;
import org.gcube.data.oai.tmplugin.repository.iterators.RepositoryIterator;
import org.gcube.data.oai.tmplugin.repository.iterators.SetIterator;
import org.gcube.data.oai.tmplugin.requests.Request;
import org.gcube.data.oai.tmplugin.requests.WrapSetsRequest;
import org.gcube.data.oai.tmplugin.utils.Constants;
import org.gcube.data.streams.Stream;
import org.gcube.data.streams.dsl.Streams;
import org.gcube.data.streams.exceptions.StreamException;
import org.gcube.data.streams.generators.Generator;
import org.gcube.data.tmf.api.exceptions.UnknownTreeException;
import org.gcube.data.trees.data.Tree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseRepository
implements Repository {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(BaseRepository.class);
    private transient Harvester connection;
    private final String url;
    private final String metadataFormat;
    private transient String description;
    private transient String name;
    private boolean wrapSetsRequest;
    private OAIDCBinder binder;

    public BaseRepository(Request request) throws Exception {
        this.wrapSetsRequest = request instanceof WrapSetsRequest;
        this.url = request.getRepositoryUrl();
        this.metadataFormat = request.getMetadataFormat();
        this.description = request.getDescription();
        this.name = request.getName();
        if (this.connect(this.url).booleanValue()) {
            this.binder = new OAIDCBinder(request);
        }
    }

    @Override
    public String url() {
        return this.url;
    }

    public String metadataFormat() {
        return this.metadataFormat;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String description() {
        return this.description;
    }

    @Override
    public Tree get(String id, List<Set> sets) throws UnknownTreeException, Exception {
        log.info("get id: " + id + " - sets: " + sets.toString());
        try {
            Record record = null;
            try {
                this.connection.getRecord(id, this.metadataFormat);
                if (!sets.isEmpty()) {
                    boolean inSomeSet = false;
                    int i = 0;
                    block4: while (i < record.getHeader().getSpecList().size()) {
                        for (Set set : sets) {
                            if (!((String)record.getHeader().getSpecList().get(i)).equals(set.id())) continue;
                            inSomeSet = true;
                            break block4;
                        }
                        ++i;
                    }
                    if (!inSomeSet) {
                        throw new UnknownTreeException();
                    }
                }
            }
            catch (Exception e) {
                throw new UnknownTreeException(id, (Throwable)e);
            }
            return this.binder.bind(record);
        }
        catch (Exception e) {
            throw new UnknownTreeException(id, (Throwable)e);
        }
    }

    @Override
    public Stream<Tree> getAllIn(List<Set> sets) {
        RecordIter records = null;
        records = sets.isEmpty() ? new RepositoryIterator(){

            @Override
            protected RecordIterator fetchRecords() throws FileNotFoundException, Exception {
                log.info("getAllIn - RepositoryIterator, sets Empty ");
                return BaseRepository.this.connection.listRecords(BaseRepository.this.metadataFormat);
            }

            public boolean isClosed() {
                return false;
            }
        } : new SetIterator(sets){

            @Override
            protected RecordIterator fetchRecords(Set set) throws Exception {
                log.info("getAllIn - SetIterator on set id: " + set.id());
                return BaseRepository.this.connection.listRecords(null, null, set.id(), BaseRepository.this.metadataFormat);
            }

            public boolean isClosed() {
                return false;
            }
        };
        Generator<Record, Tree> parser = new Generator<Record, Tree>(){

            public Tree yield(Record record) {
                try {
                    return BaseRepository.this.binder.bind(record);
                }
                catch (Exception e) {
                    throw new StreamException();
                }
            }
        };
        return Streams.pipe((Stream)records).through((Generator)parser);
    }

    @Override
    public Summary summary(List<Set> sets) throws Exception {
        RecordIter records = null;
        records = sets == null || sets.isEmpty() ? new RepositoryIterator(){

            @Override
            protected RecordIterator fetchRecords() throws FileNotFoundException, Exception {
                log.info("summary RepositoryIterator, no set ");
                log.info("fetchRecords sets.isEmpty");
                return BaseRepository.this.connection.listRecords(BaseRepository.this.metadataFormat);
            }

            public boolean isClosed() {
                return false;
            }
        } : new SetIterator(sets){

            @Override
            protected RecordIterator fetchRecords(Set set) throws Exception {
                log.info("summary SetIterator on set id: " + set.id());
                return BaseRepository.this.connection.listRecords(null, null, set.id(), BaseRepository.this.metadataFormat);
            }

            public boolean isClosed() {
                return false;
            }
        };
        Calendar lastUpdate = null;
        long cardinality = 0L;
        while (records.hasNext()) {
            try {
                Record record = (Record)records.next();
                if (record == null || record.getMetadata() == null || record.IsDeleted().booleanValue()) continue;
                ++cardinality;
                Calendar tempUpdate = null;
                String datastamp = null;
                try {
                    datastamp = record.getHeader().getDatestamp();
                    if (datastamp == null) continue;
                    tempUpdate = Constants.getDate(datastamp);
                    if (lastUpdate != null && !tempUpdate.after(lastUpdate)) continue;
                    lastUpdate = tempUpdate;
                }
                catch (Exception e) {
                    log.error("Error getting last update ", (Throwable)e);
                }
            }
            catch (Exception e) {
                log.error("could not count record", (Throwable)e);
            }
        }
        if (lastUpdate == null) {
            throw new Exception();
        }
        return new Summary(lastUpdate, cardinality);
    }

    private Boolean connect(String url) throws Exception {
        log.info("connecting to repository @ " + url);
        try {
            this.connection = new Harvester(url);
            if (this.connection != null) {
                Identify identify = this.connection.identify();
                this.name = identify.getRepositoryName();
                if (this.name != null) {
                    this.description = this.name;
                } else {
                    log.info("0 records");
                }
            }
        }
        catch (Exception e) {
            log.error("could not connect to repository @ " + url);
            return false;
        }
        return true;
    }

    @Override
    public List<Set> getSetsWith(List<String> setIds) {
        log.info("getSetsWith " + setIds.toString());
        boolean emptySetsList = setIds.isEmpty();
        log.info(emptySetsList ? "retrieving all sets in repository " + this.url : "retrieving sets {} in repository " + this.url, setIds);
        ArrayList<Set> output = new ArrayList<Set>();
        if (!emptySetsList || this.wrapSetsRequest) {
            ArrayList<String> done = new ArrayList<String>(setIds);
            try {
                List OAISets = this.connection.listSets();
                for (org.gcube.common.repository.Set set : OAISets) {
                    String setId = set.getSetSpec();
                    if (!emptySetsList && !done.contains(setId)) continue;
                    String description = set.getSetName() != "" ? set.getSetName() : null;
                    output.add(new Set(setId, set.getSetName(), description));
                    done.remove(setId);
                    if (emptySetsList || !done.isEmpty()) {
                        continue;
                    }
                    break;
                }
            }
            catch (Exception e) {
                log.error("could not process sets in repository " + this.url, (Throwable)e);
                throw new RuntimeException("could not process sets in repository " + this.url, e);
            }
            if (!done.isEmpty()) {
                log.error("unkwnon sets " + done + " in repository " + this.url);
                throw new RuntimeException("unkwnon sets " + done + " in repository " + this.url);
            }
        }
        return output;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.url == null) {
            throw new IOException("invalid serialisation, missing respository url");
        }
        try {
            this.connect(this.url);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }
}

