/**
 * 
 */
package org.gcube.data.oai.tmplugin.repository.iterators;

import java.net.URI;
import java.util.NoSuchElementException;

import org.gcube.data.oai.tmplugin.binders.OAIDCBinder;
import org.gcube.data.streams.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

import org.gcube.common.OAIException;
import org.gcube.common.OAIRecord;
import org.gcube.common.OAIRecordList;

/**
 * @author Fabio Simeoni
 *
 */
public abstract class RecordIterator implements Stream<OAIRecord> {

	OAIRecordList records = null;
	private final static Logger log = LoggerFactory.getLogger(RecordIterator.class);

	public OAIRecord next()  {

		if (!hasNext())
			throw new NoSuchElementException();

		OAIRecord record = null;

		try {
			do{
				record = records.getCurrentItem();
				records.moveNext();
			}while(notValid(record));
			
		} catch (OAIException e) {
			log.warn("an error occurred trying to retrieve a record (moving to the next element)",e);	
		}

		return record;

	};

	//check if the record is valid
	private boolean notValid(OAIRecord record) throws OAIException {
//		log.info("record " + record.getIdentifier());
		if (record==null || record.deleted() || !record.isRecordValid() || record.getMetadata()==null){			
			log.info("record not valid " + record.getIdentifier());
			return true;
		}
		return false;
	}

	public URI locator() {return null;} //unused

	/**{@inheritDoc}*/
	@Override
	public void close() {}

	@Override
	public void remove() {
	}

}
