/**
 * 
 */
package org.gcube.data.oai.tmplugin.repository.iterators;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import org.gcube.common.OAIException;
import org.gcube.common.OAIRecordList;


/**
 * @author Fabio Simeoni
 *
 */
public abstract class RepositoryIterator extends RecordIterator {

	private static final Logger log = LoggerFactory.getLogger(RepositoryIterator.class);

	@Override
	public boolean hasNext() {
		
		try {
			if (records==null) {
					records = fetchRecords();
					log.trace("expecting to iterate over a max of {}",records.getCompleteSize());
					return hasNext();
			}
			else
				return records.moreItems();
			
		}
		catch(OAIException moveToNextSet) {
			log.error("could not list records from {}",moveToNextSet);
			return false;
		}
		
			
	}
	
	protected abstract OAIRecordList fetchRecords() throws OAIException;
}
