/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.oai.tmplugin.binders;

import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URI;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.codec.binary.Base64;
import org.gcube.data.oai.tmplugin.Constants;
import org.gcube.data.oai.tmplugin.RepositoryProvider;
import org.gcube.data.oai.tmplugin.Utils;
import org.gcube.data.oai.tmplugin.requests.Request;
import org.gcube.data.trees.data.Edge;
import org.gcube.data.trees.data.InnerNode;
import org.gcube.data.trees.data.Node;
import org.gcube.data.trees.data.Nodes;
import org.gcube.data.trees.data.Tree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import uiuc.oai.OAIRecord;

public class OAIDCBinder
implements Serializable {
    private static final long serialVersionUID = -8037198825787888863L;
    private static final Logger log = LoggerFactory.getLogger(OAIDCBinder.class);
    private static final DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
    private static final TransformerFactory transformerFactory = TransformerFactory.newInstance();
    private static final String oaidc_schema = "http://www.openarchives.org/OAI/2.0/oai_dc/";
    private static final String oaidc_prefix = "oai_dc";
    private Request request;

    public OAIDCBinder(Request request) {
        this.request = request;
    }

    public OAIDCBinder(RepositoryProvider p) {
    }

    public Tree bind(OAIRecord record) throws Exception {
        try {
            NodeList nl;
            XPath xPath;
            XPathFactory xpathFactory;
            Edge nameEdge;
            Edge contentEdge;
            Edge lengthEdge;
            Edge mimeTypeEdge;
            Document metadataDocument;
            Edge lastUpdateTimeEdge;
            Edge creationTimeEdge;
            Tree tree;
            block18: {
                tree = new Tree(Utils.idEncoder(record.getIdentifier()));
                Calendar timestamp = Constants.getDate(record.getDatestamp());
                creationTimeEdge = Nodes.e((String)"creationTime", (Object)timestamp);
                lastUpdateTimeEdge = Nodes.e((String)"lastUpdateTime", (Object)timestamp);
                tree.add(new Edge[]{creationTimeEdge, lastUpdateTimeEdge});
                StringWriter writer = new StringWriter();
                Transformer transformer = transformerFactory.newTransformer();
                transformer.setOutputProperty("encoding", "utf-8");
                transformer.setOutputProperty("omit-xml-declaration", "yes");
                transformer.transform(new DOMSource(record.getMetadata()), new StreamResult(writer));
                String metadata = writer.toString();
                try {
                    Edge mEdge = this.createMetadataEdge(metadata, oaidc_prefix, oaidc_schema, tree.id(), creationTimeEdge, lastUpdateTimeEdge);
                    tree.add(mEdge);
                }
                catch (Exception te) {
                    log.warn("error retrieving the metadata", (Throwable)te);
                }
                metadataDocument = factory.newDocumentBuilder().parse(new InputSource(new StringReader(writer.toString())));
                mimeTypeEdge = Nodes.e((String)"mimeType", (Object)"");
                lengthEdge = Nodes.e((String)"length", (Object)0);
                contentEdge = Nodes.e((String)"url", (Object)"");
                nameEdge = Nodes.e((String)"name", (Object)Utils.idEncoder(record.getIdentifier()));
                xpathFactory = XPathFactory.newInstance();
                if (this.request.contentXPath() != null) {
                    try {
                        xPath = xpathFactory.newXPath();
                        nl = (NodeList)xPath.evaluate(this.request.contentXPath(), metadataDocument, XPathConstants.NODESET);
                        if (nl.item(0) == null) break block18;
                        String contentUri = nl.item(0).getTextContent();
                        try {
                            mimeTypeEdge = Nodes.e((String)"mimeType", (Object)"text/url");
                        }
                        catch (Exception e) {
                            log.warn("could not retrieve mime type for " + tree.id());
                        }
                        try {
                            lengthEdge = Nodes.e((String)"length", (Object)contentUri.getBytes("utf-8").length);
                        }
                        catch (Exception e) {
                            log.warn("could not retrieve content length for " + tree.id());
                        }
                        contentEdge = Nodes.e((String)"url", (Object)contentUri);
                    }
                    catch (Throwable e) {
                        log.error("could not retrieve content for " + record.getIdentifier(), e);
                    }
                }
            }
            if (this.request.titleXPath() != null) {
                try {
                    xPath = xpathFactory.newXPath();
                    nl = (NodeList)xPath.evaluate(this.request.titleXPath(), metadataDocument, XPathConstants.NODESET);
                    if (nl.item(0) != null) {
                        String recordName = nl.item(0).getTextContent();
                        nameEdge = Nodes.e((String)"name", (Object)recordName);
                    }
                }
                catch (Exception e) {
                    log.warn("cannot calculate the title of " + tree.id(), (Throwable)e);
                }
            }
            tree.add(new Edge[]{mimeTypeEdge, lengthEdge, contentEdge, nameEdge});
            int i = 0;
            while (i < this.request.getAlternativesXPath().size()) {
                String path = this.request.getAlternativesXPath().get(i);
                try {
                    tree.add(this.createAlternatives(metadataDocument, i, path, creationTimeEdge, lastUpdateTimeEdge));
                }
                catch (Exception te) {
                    log.warn("could not retrieve alternatives in " + tree.id() + " with path " + path, (Throwable)te);
                }
                ++i;
            }
            return tree;
        }
        catch (Exception e) {
            log.error("could not convert record:" + record, (Throwable)e);
            throw new Exception("could not convert record", e);
        }
    }

    private List<Edge> createAlternatives(Document metadataDocument, int identifier, String path, Edge creationTimeEdge, Edge lastUpdateTimeEdge) throws Exception {
        XPathFactory factory = XPathFactory.newInstance();
        XPath xPath = factory.newXPath();
        NodeList nl = (NodeList)xPath.evaluate(path, metadataDocument, XPathConstants.NODESET);
        ArrayList<Edge> edgeList = new ArrayList<Edge>();
        int i = 0;
        while (i < nl.getLength()) {
            String alternativeUri = nl.item(i).getTextContent();
            Edge mimeTypeEdge = Nodes.e((String)"mimeType", (Object)"none");
            Edge lengthEdge = Nodes.e((String)"length", (Object)"none");
            URI uri = new URI(alternativeUri);
            URLConnection urlConnection = uri.toURL().openConnection();
            try {
                mimeTypeEdge = Nodes.e((String)"mimeType", (Object)urlConnection.getContentType());
            }
            catch (Exception e) {
                log.warn("impossible to retrieve the mimeType for alternative");
            }
            try {
                lengthEdge = Nodes.e((String)"length", (Object)urlConnection.getContentLength());
            }
            catch (Exception e) {
                log.warn("impossible to retrieve the content length for alternative");
            }
            edgeList.add(Nodes.e((String)"hasAlternative", (Node)Nodes.n((String)(String.valueOf(identifier) + "-alternative-" + i), (Edge[])new Edge[]{mimeTypeEdge, lengthEdge, Nodes.e((String)"name", (Object)(String.valueOf(identifier) + "-" + i)), Nodes.e((String)"url", (Object)alternativeUri), creationTimeEdge, lastUpdateTimeEdge})));
            ++i;
        }
        return edgeList;
    }

    private Edge createMetadataEdge(String metadata, String prefix, String schema, String identifier, Edge createTimeEdge, Edge lastUpdateTimeEdge) throws Exception {
        return Nodes.e((String)"isDescribedBy", (Node)new InnerNode(String.valueOf(identifier) + "-" + prefix, new Edge[]{Nodes.e((String)"mimeType", (Object)"text/xml"), Nodes.e((String)"length", (Object)metadata.length()), Nodes.e((String)"language", (Object)"unknown"), Nodes.e((String)"schemaName", (Object)prefix), Nodes.e((String)"schemaURI", (Object)schema), Nodes.e((String)"bytestream", (Object)Base64.encodeBase64((byte[])metadata.getBytes("utf-8"))), createTimeEdge, lastUpdateTimeEdge}));
    }
}

