/**
 * 
 */
package org.gcube.data.oai.tmplugin.requests;

import static java.util.Arrays.*;

import java.util.ArrayList;
import java.util.List;

import javax.xml.bind.annotation.XmlElement;

/**
 * Base implementation for plugin requests
 * 
 * @author Fabio Simeoni
 * @author Lucio Lelii (CNR)
 * 
 */
public abstract class Request {

	@XmlElement
	private String url;
	@XmlElement
	private List<String> sets = new ArrayList<String>();

	Request() {}

	Request(String url) throws IllegalArgumentException {

		if (url == null || url.isEmpty())
			throw new IllegalArgumentException("repository url is null or empty");

		this.url = url;
	}

	/**
	 * Returns the URL of the target OAI repository
	 * @return the URL
	 */
	public String repositoryUrl() {
		return url;
	}

	public List<String> sets() {
		return sets;
	}

	public void addSets(String... setIds) {
		if (setIds != null)
			sets.addAll(asList(setIds));
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result
				+ ((url == null) ? 0 : url.hashCode());
		result = prime * result + ((sets == null) ? 0 : sets.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		Request other = (Request) obj;
		if (url == null) {
			if (other.url != null)
				return false;
		} else if (!url.equals(other.url))
			return false;
		if (sets == null) {
			if (other.sets != null)
				return false;
		} else if (!sets.equals(other.sets))
			return false;
		return true;
	}

	
}
