/**
 * 
 */
package org.gcube.data.oai.tmplugin.repository.iterators;

import java.net.URI;
import java.util.NoSuchElementException;

import org.gcube.data.streams.Stream;

import uiuc.oai.OAIException;
import uiuc.oai.OAIRecord;
import uiuc.oai.OAIRecordList;

/**
 * @author Fabio Simeoni
 *
 */
public abstract class RecordIterator implements Stream<OAIRecord> {

	OAIRecordList records = null;
	
	
	public OAIRecord next()  {
		
		if (!hasNext())
			throw new NoSuchElementException();
		
		OAIRecord record = records.getCurrentItem();
		try {
			records.moveNext();
		}
		catch(OAIException e) {
			throw new RuntimeException(e);
		}
		return record;
	};
	
	public URI locator() {return null;} //unused
	
	/**{@inheritDoc}*/
	@Override
	public void close() {}
	
	@Override
	public void remove() {
	}

}
