/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.harmonization.occurrence.impl.readers.formats;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import org.apache.commons.io.input.CountingInputStream;
import org.apache.commons.lang.StringEscapeUtils;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.data.harmonization.occurrence.impl.readers.StreamProgress;
import org.gcube.data.harmonization.occurrence.impl.readers.XMLParserConfiguration;
import org.gcube.data.spd.plugin.fwk.model.BasisOfRecord;
import org.gcube.data.spd.plugin.fwk.model.OccurrencePoint;
import org.gcube.data.spd.plugin.fwk.writers.rswrapper.ResultWrapper;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class DarwinCoreReader
extends DefaultHandler {
    private static final GCUBELog logger = new GCUBELog(DarwinCoreReader.class);
    private DateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    private ResultWrapper<OccurrencePoint> wrapper = null;
    private OccurrencePoint currentPoint = null;
    private StringBuilder stringBuilder;
    private StreamProgress progress;
    private XMLParserConfiguration config;
    private CountingInputStream cis;

    public DarwinCoreReader(ResultWrapper<OccurrencePoint> wrapper, StreamProgress progress, XMLParserConfiguration config, CountingInputStream cis) {
        this.progress = progress;
        this.wrapper = wrapper;
        this.config = config;
        this.cis = cis;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        super.startElement(uri, localName, qName, attributes);
        if (qName.equals("SimpleDarwinRecord")) {
            this.currentPoint = new OccurrencePoint("");
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.currentPoint != null) {
            StringBuilder local = new StringBuilder();
            for (int i = start; i < start + length; ++i) {
                local.append(ch[i]);
            }
            this.stringBuilder = new StringBuilder(StringEscapeUtils.escapeXml((String)local.toString()));
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.currentPoint != null) {
            if (qName.equals("SimpleDarwinRecord")) {
                try {
                    this.wrapper.add((Object)this.currentPoint);
                    this.progress.setElaboratedLenght(this.cis.getCount());
                }
                catch (Exception e) {
                    this.progress.setFailureReason("Unable to stream data");
                    this.progress.setFailureDetails(e.getMessage());
                    this.progress.setState(StreamProgress.OperationState.FAILED);
                }
            } else if (qName.equals("dc:modified")) {
                try {
                    Calendar cal = Calendar.getInstance();
                    cal.setTime(this.df.parse(this.stringBuilder.toString()));
                    this.currentPoint.setModified(cal);
                }
                catch (ParseException e) {
                    logger.debug((Object)("Unable to parse modified " + this.stringBuilder.toString()));
                }
            } else if (qName.equals("dwc:basisOfRecord")) {
                try {
                    this.currentPoint.setBasisOfRecord(BasisOfRecord.valueOf((String)this.stringBuilder.toString()));
                }
                catch (Exception e) {
                    logger.debug((Object)("Unable to parse basis of record " + this.stringBuilder.toString()));
                }
            } else if (qName.equals("dwc:institutionCode")) {
                this.currentPoint.setInstitutionCode(this.stringBuilder.toString());
            } else if (qName.equals("dwc:collectionCode")) {
                this.currentPoint.setCollectionCode(this.stringBuilder.toString());
            } else if (qName.equals("dwc:catalogNumber")) {
                this.currentPoint.setCatalogueNumber(this.stringBuilder.toString());
            } else if (qName.equals("dwc:recordedBy")) {
                this.currentPoint.setRecordedBy(this.stringBuilder.toString());
            } else if (qName.equals("dwc:scientificName")) {
                this.currentPoint.setScientificName(this.stringBuilder.toString());
            } else if (qName.equals("dwc:kingdom")) {
                this.currentPoint.setKingdom(this.stringBuilder.toString());
            } else if (qName.equals("dwc:family")) {
                this.currentPoint.setFamily(this.stringBuilder.toString());
            } else if (qName.equals("dwc:locality")) {
                this.currentPoint.setLocality(this.stringBuilder.toString());
            } else if (qName.equals("dwc:eventDate")) {
                try {
                    Calendar cal = Calendar.getInstance();
                    cal.setTime(this.df.parse(this.stringBuilder.toString()));
                    this.currentPoint.setEventDate(cal);
                }
                catch (ParseException e) {
                    logger.debug((Object)("Unable to parse eventDate " + this.stringBuilder.toString()));
                }
            } else if (qName.equals("dwc:decimalLatitude")) {
                try {
                    this.currentPoint.setDecimalLatitude(Double.parseDouble(this.stringBuilder.toString()));
                }
                catch (Exception e) {
                    logger.debug((Object)("Unable to parse decimalLatitude " + this.stringBuilder.toString()));
                }
            } else if (qName.equals("dwc:decimalLongitude")) {
                try {
                    this.currentPoint.setDecimalLongitude(Double.parseDouble(this.stringBuilder.toString()));
                }
                catch (Exception e) {
                    logger.debug((Object)("Unable to parse decimalLongitude " + this.stringBuilder.toString()));
                }
            } else if (qName.equals("dwc:coordinateUncertaintyInMeters")) {
                this.currentPoint.setCoordinateUncertaintyInMeters(this.stringBuilder.toString());
            } else if (qName.equals("dwc:maximumDepthInMeters")) {
                try {
                    this.currentPoint.setMaxDepth(Double.parseDouble(this.stringBuilder.toString()));
                }
                catch (Exception e) {
                    logger.debug((Object)("Unable to parse max depth " + this.stringBuilder.toString()));
                }
            } else if (qName.equals("dwc:minimumDepthInMeters")) {
                try {
                    this.currentPoint.setMinDepth(Double.parseDouble(this.stringBuilder.toString()));
                }
                catch (Exception e) {
                    logger.debug((Object)("Unable to parse min depth " + this.stringBuilder.toString()));
                }
            }
        }
    }

    @Override
    public void endDocument() throws SAXException {
        try {
            this.wrapper.close();
        }
        catch (Exception e) {
            logger.error((Object)"Unable to close Stream", (Throwable)e);
        }
    }
}

