/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.harmonization.occurrence.services;

import com.j256.ormlite.dao.Dao;
import com.j256.ormlite.dao.DaoManager;
import com.j256.ormlite.jdbc.JdbcConnectionSource;
import com.j256.ormlite.jdbc.JdbcPooledConnectionSource;
import com.j256.ormlite.support.ConnectionSource;
import com.j256.ormlite.table.TableUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Properties;
import org.gcube.common.core.contexts.GCUBEServiceContext;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.informationsystem.client.AtomicCondition;
import org.gcube.common.core.informationsystem.client.ISClient;
import org.gcube.common.core.informationsystem.client.ISQuery;
import org.gcube.common.core.informationsystem.client.queries.GCUBERuntimeResourceQuery;
import org.gcube.common.core.resources.GCUBERuntimeResource;
import org.gcube.common.core.resources.runtime.AccessPoint;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.data.harmonization.occurrence.db.model.ImportReference;
import org.gcube.data.harmonization.occurrence.db.model.MergeReference;
import org.gcube.data.harmonization.occurrence.db.model.ToMergeImported;
import org.gcube.data.harmonization.occurrence.operating.ImportHandler;
import org.gcube.data.harmonization.occurrence.operating.MergeHandler;
import org.gcube.data.harmonization.occurrence.operating.OperatingModule;
import org.gcube.data.harmonization.occurrence.operating.OperatingModuleConfiguration;

public class ServiceContext
extends GCUBEServiceContext {
    private static ServiceContext cache = new ServiceContext();
    private Properties props;
    private OperatingModule<ImportReference, ImportHandler> importModule;
    private OperatingModule<MergeReference, MergeHandler> mergeModule;
    private JdbcConnectionSource connectionSource;
    private Dao<ImportReference, String> importDao = null;
    private Dao<MergeReference, String> mergeDao = null;
    private Dao<ToMergeImported, Integer> toMergeDao = null;

    public static ServiceContext getContext() {
        return cache;
    }

    private ServiceContext() {
    }

    protected String getJNDIName() {
        return "gcube/data/harmonization/occurrence";
    }

    protected void onInitialisation() throws Exception {
        InputStream is = null;
        try {
            try {
                this.props = new Properties();
                is = new FileInputStream(this.getFile("config.properties", new boolean[]{false}));
                this.props.load(is);
                is.close();
                this.logger.debug((Object)("loaded properties file :" + this.props.toString()));
            }
            catch (Exception e) {
                this.logger.fatal((Object)"Unable to read configuration file", (Throwable)e);
                throw e;
            }
        }
        finally {
            is.close();
        }
        String DBconnectionString = null;
        try {
            if (Boolean.parseBoolean(this.props.getProperty("USE_EMBEDDED_DATABASE"))) {
                DBconnectionString = "jdbc:h2:mem:occurrence";
            } else {
                this.logger.trace((Object)"Looking for database runtime resource...");
                ISClient isClient = (ISClient)GHNContext.getImplementation(ISClient.class);
                GCUBERuntimeResourceQuery runtimeQuery = (GCUBERuntimeResourceQuery)isClient.getQuery(GCUBERuntimeResourceQuery.class);
                runtimeQuery.addAtomicConditions(new AtomicCondition[]{new AtomicCondition("//Profile/Category", this.props.getProperty("INTERNAL_DB_CATEGORY"))});
                runtimeQuery.addAtomicConditions(new AtomicCondition[]{new AtomicCondition("//Profile/Platform/Name", this.props.getProperty("INTERNAL_DB_PLATFORM"))});
                boolean found = false;
                GCUBEScope[] gCUBEScopeArray = this.getStartScopes();
                int n = gCUBEScopeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    GCUBEScope scope = gCUBEScopeArray[n2];
                    List list = isClient.execute((ISQuery)runtimeQuery, scope);
                    this.logger.debug((Object)("Found " + list.size() + " matching resources under scope " + scope));
                    for (GCUBERuntimeResource rr : list) {
                        if (found) break;
                        try {
                            for (AccessPoint access : rr.getAccessPoints()) {
                                if (!access.getEntryname().equals(this.props.getProperty("INTERNAL_DB_ENTRYPOINT")) || !access.getAllPropertyNames().contains(this.props.getProperty("INTERNAL_DB_SCHEMA_PROPERTY")) || !access.getProperty(this.props.getProperty("INTERNAL_DB_SCHEMA_PROPERTY")).equals(this.props.getProperty("INTERNAL_DB_SCHEMA_VALUE"))) continue;
                                this.logger.debug((Object)("Found Access point " + access.getEntryname() + " in " + rr.getName() + " [ ID : " + rr.getID() + "]"));
                                DBconnectionString = "jdbc:postgres:" + access.getEndpoint() + ";user=" + access.getUsername() + ";password=" + access.getPassword();
                                found = true;
                            }
                        }
                        catch (Exception e) {
                            this.logger.warn((Object)("Unable to parse resource [ID :" + rr.getID() + "]"), (Throwable)e);
                        }
                    }
                    if (found) break;
                    ++n2;
                }
            }
            this.connectionSource = new JdbcPooledConnectionSource(DBconnectionString);
        }
        catch (Exception e) {
            this.logger.fatal((Object)("Unable to connect to " + DBconnectionString), (Throwable)e);
            throw e;
        }
        try {
            this.importDao = DaoManager.createDao((ConnectionSource)this.connectionSource, ImportReference.class);
            this.mergeDao = DaoManager.createDao((ConnectionSource)this.connectionSource, MergeReference.class);
            this.toMergeDao = DaoManager.createDao((ConnectionSource)this.connectionSource, ToMergeImported.class);
            TableUtils.createTableIfNotExists((ConnectionSource)this.connectionSource, ImportReference.class);
            TableUtils.createTableIfNotExists((ConnectionSource)this.connectionSource, MergeReference.class);
            TableUtils.createTableIfNotExists((ConnectionSource)this.connectionSource, ToMergeImported.class);
        }
        catch (Exception e) {
            this.logger.fatal((Object)"Unable to init Database", (Throwable)e);
            throw e;
        }
        String queueConnectionHost = "localhost";
        try {
            OperatingModuleConfiguration<ImportReference, ImportHandler> importConfiguration = new OperatingModuleConfiguration<ImportReference, ImportHandler>();
            importConfiguration.setDao(this.importDao);
            importConfiguration.setHanlderClass(ImportHandler.class);
            importConfiguration.setMaxWorkerThreads(Integer.parseInt(this.props.getProperty("IMPORTER_MAX_WORKER")));
            importConfiguration.setMessageRoutingKey("org.gcube.data.harmonization.occurrence.import");
            importConfiguration.setQueueConnectionHost(queueConnectionHost);
            this.importModule = new OperatingModule();
            this.importModule.init(importConfiguration);
        }
        catch (Exception e) {
            this.logger.fatal((Object)"Unable to init Import Module", (Throwable)e);
            throw e;
        }
        try {
            OperatingModuleConfiguration<MergeReference, MergeHandler> mergeConfiguration = new OperatingModuleConfiguration<MergeReference, MergeHandler>();
            mergeConfiguration.setDao(this.mergeDao);
            mergeConfiguration.setHanlderClass(MergeHandler.class);
            mergeConfiguration.setMaxWorkerThreads(Integer.parseInt(this.props.getProperty("MERGE_MAX_WORKER")));
            mergeConfiguration.setMessageRoutingKey("org.gcube.data.harmonization.occurrence.merge");
            mergeConfiguration.setQueueConnectionHost(queueConnectionHost);
            this.mergeModule = new OperatingModule();
            this.mergeModule.init(mergeConfiguration);
        }
        catch (Exception e) {
            this.logger.fatal((Object)"Unable to init Merge Module", (Throwable)e);
            throw e;
        }
    }

    public Dao<ImportReference, String> getImportDao() {
        return this.importDao;
    }

    public OperatingModule<ImportReference, ImportHandler> getImportModule() {
        return this.importModule;
    }

    public Dao<MergeReference, String> getMergeDao() {
        return this.mergeDao;
    }

    public OperatingModule<MergeReference, MergeHandler> getMergeModule() {
        return this.mergeModule;
    }

    public Dao<ToMergeImported, Integer> getToMergeDao() {
        return this.toMergeDao;
    }

    public String getFolderPath(FOLDERS folderName) {
        String persistencePath = String.valueOf(ServiceContext.getContext().getPersistenceRoot().getAbsolutePath()) + File.separator + (Object)((Object)folderName);
        File f = new File(persistencePath);
        if (!f.exists()) {
            this.logger.debug((Object)("Creating persistence folder " + persistencePath));
            f.mkdirs();
            try {
                Process proc = Runtime.getRuntime().exec("chmod -R 777 " + persistencePath);
                try {
                    proc.waitFor();
                }
                catch (InterruptedException e) {
                    int exitValue = proc.exitValue();
                    this.logger.debug((Object)("Permission execution exit value = " + exitValue));
                }
            }
            catch (IOException e) {
                this.logger.warn((Object)"Unexpected Exception", (Throwable)e);
            }
        }
        return persistencePath;
    }

    public static enum FOLDERS {
        IMPORTED;

    }
}

