/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.harmonization.occurrence.db.model;

import com.j256.ormlite.field.DatabaseField;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.data.harmonization.occurrence.db.model.ExecutionState;
import org.gcube.data.harmonization.occurrence.operating.OperatingModuleConfiguration;
import org.gcube.data.harmonization.occurrence.util.Utils;

public abstract class ExecutionReference {
    protected static GCUBELog logger = new GCUBELog(OperatingModuleConfiguration.class);
    public static final String ID_FIELD = "id";
    public static final String SUBMISSION_FIELD = "submissiontime";
    public static final String START_FIELD = "starttime";
    public static final String COMPLETION_FIELD = "completiontime";
    public static final String AUTHOR_FIELD = "author";
    public static final String STATE_FIELD = "state";
    public static final String SCOPE_FIELD = "scope";
    public static final String PROGRESS_FIELD = "progress";
    @DatabaseField(id=true, width=70, columnName="id")
    private String id;
    @DatabaseField(canBeNull=false, columnName="submissiontime")
    private Long submissionTime;
    @DatabaseField(defaultValue="0", columnName="starttime")
    private Long startTime = 0L;
    @DatabaseField(defaultValue="0", columnName="completiontime")
    private Long completionTime = 0L;
    @DatabaseField(canBeNull=false, width=100, columnName="author")
    private String author;
    @DatabaseField(canBeNull=false, width=30, columnName="state")
    private ExecutionState state = ExecutionState.NEW;
    @DatabaseField(canBeNull=false, width=150, columnName="scope")
    private String scope;
    @DatabaseField(canBeNull=false, defaultValue="0", columnName="progress")
    private Double progress = 0.0;

    public abstract void updateStatus(ExecutionState var1) throws Exception;

    public ExecutionReference(ExecutionRequest request) {
        this.setId(Utils.generateId("", ""));
        this.setStartTime(0L);
        this.setCompletionTime(0L);
        this.setSubmissionTime(System.currentTimeMillis());
        this.setAuthor(request.getAuthor());
        this.setProgress(0.0);
        this.setScope("" + request.getScope());
        this.setState(ExecutionState.NEW);
    }

    public ExecutionReference() {
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Long getSubmissionTime() {
        return this.submissionTime;
    }

    public void setSubmissionTime(Long submissionTime) {
        this.submissionTime = submissionTime;
    }

    public Long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Long startTime) {
        this.startTime = startTime;
    }

    public Long getCompletionTime() {
        return this.completionTime;
    }

    public void setCompletionTime(Long completionTime) {
        this.completionTime = completionTime;
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public ExecutionState getState() {
        return this.state;
    }

    public void setState(ExecutionState state) {
        this.state = state;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public Double getProgress() {
        return this.progress;
    }

    public void setProgress(Double progress) {
        this.progress = progress;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ExecutionReference other = (ExecutionReference)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ExecutionReference [id=");
        builder.append(this.id);
        builder.append(", submissionTime=");
        builder.append(this.submissionTime);
        builder.append(", startTime=");
        builder.append(this.startTime);
        builder.append(", completionTime=");
        builder.append(this.completionTime);
        builder.append(", author=");
        builder.append(this.author);
        builder.append(", state=");
        builder.append((Object)this.state);
        builder.append(", scope=");
        builder.append(this.scope);
        builder.append("]");
        return builder.toString();
    }

    public static abstract class ExecutionRequest {
        private GCUBEScope scope;
        private String author;

        public ExecutionRequest(GCUBEScope scope, String author) {
            this.scope = scope;
            this.author = author;
        }

        public String getAuthor() {
            return this.author;
        }

        public GCUBEScope getScope() {
            return this.scope;
        }
    }
}

