package org.gcube.data.harmonization.occurrence.db.model;

import java.sql.SQLException;
import java.util.List;

import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.data.harmonization.occurrence.services.ServiceContext;

import com.j256.ormlite.dao.Dao;
import com.j256.ormlite.dao.ForeignCollection;
import com.j256.ormlite.field.DatabaseField;
import com.j256.ormlite.field.ForeignCollectionField;
import com.j256.ormlite.table.DatabaseTable;

@DatabaseTable
public class MergeReference extends ExecutionReference {

	
	public static class MergeRequest extends ExecutionReference.ExecutionRequest{
		private List<String> toMergeIds;

		public MergeRequest(GCUBEScope scope, String author,
				List<String> toMergeIds) {
			super(scope, author);
			this.toMergeIds = toMergeIds;
		}
		public List<String> getToMergeIds() {
			return toMergeIds;
		}
	}
	
	
	
	
	public static final String TO_MERGE_FIELD="to_merge";
	public static final String MERGED_TABLE="merged_table";
	
	
	public MergeReference(MergeRequest request) throws SQLException {
		super(request);
		setMergedTable(null);
		Dao<ImportReference,String> importDao=ServiceContext.getContext().getImportDao();
		Dao<ToMergeImported,Integer> relationDao=ServiceContext.getContext().getToMergeDao();
		Dao<MergeReference,String> mergeDao=ServiceContext.getContext().getMergeDao();
		try{
			logger.debug("Creating merge reference..");
			mergeDao.create(this);
			logger.debug("Creating relations for merge");
			
			for(String importId:request.getToMergeIds()){
				ToMergeImported relation=new ToMergeImported(importDao.queryForId(importId), this);
				relationDao.create(relation);
			}
			logger.debug("Merge Reference created");
		}catch(SQLException e){
			logger.error("Something went wrong, cleaning references..");
			if(getToMergeImportedReferences()!=null)
				logger.debug("Deleted "+relationDao.delete(getToMergeImportedReferences())+" relation rows");				
			if(mergeDao.idExists(getId())) mergeDao.deleteById(getId());
			throw e;
		}
	}
	
	public MergeReference() {
		// TODO Auto-generated constructor stub
	}
	
	@ForeignCollectionField(eager = false,columnName=TO_MERGE_FIELD)
	private ForeignCollection<ToMergeImported> toMergeImportedReferences;
	
	@DatabaseField(columnName=MERGED_TABLE)
	private String mergedTable;
	
	
	
	

	/**
	 * @return the toMergeImportedReferences
	 */
	public ForeignCollection<ToMergeImported> getToMergeImportedReferences() {
		return toMergeImportedReferences;
	}

	/**
	 * @param toMergeImportedReferences the toMergeImportedReferences to set
	 */
	public void setToMergeImportedReferences(
			ForeignCollection<ToMergeImported> toMergeImportedReferences) {
		this.toMergeImportedReferences = toMergeImportedReferences;
	}

	/**
	 * @return the mergedTable
	 */
	public String getMergedTable() {
		return mergedTable;
	}

	/**
	 * @param mergedTable the mergedTable to set
	 */
	public void setMergedTable(String mergedTable) {
		this.mergedTable = mergedTable;
	}

	/* (non-Javadoc)
	 * @see org.gcube.dataharmonization.occurrencereconciliation.impl.model.ExecutionReference#equals(java.lang.Object)
	 */
	@Override
	public boolean equals(Object obj) {		
		return super.equals(obj);
	}
	
	/* (non-Javadoc)
	 * @see org.gcube.dataharmonization.occurrencereconciliation.impl.model.ExecutionReference#hashCode()
	 */
	@Override
	public int hashCode() {
		// TODO Auto-generated method stub
		return super.hashCode();
	}

	@Override
	public void updateStatus(ExecutionState toSet) throws Exception {
			setState(toSet);
			if(toSet.equals(ExecutionState.STARTED)) 
				setStartTime(System.currentTimeMillis());
			else if(toSet.equals(ExecutionState.COMPLETED)||toSet.equals(ExecutionState.ERROR))
				setCompletionTime(System.currentTimeMillis());
			ServiceContext.getContext().getMergeDao().update(this);
	}
}
