/**
 * 
 */
package org.gcube.data.fishfinder.tmplugin.requests;

import java.io.Serializable;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Base implementation for plugin requests
 * 
 * @author "Valentina Marioli valentina.marioli@isti.cnr.it"
 *
 */
@XmlRootElement
@XmlAccessorType(XmlAccessType.FIELD)
public abstract class Request implements Serializable{
	private static Logger log = LoggerFactory.getLogger(Request.class);
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	@XmlElement
	private String name;
	@XmlElement
	private String description;


	Request() {}

	/**
	 * Returns a name for the source to bind.
	 * @return the name
	 */
	public String getName() {
		return name;
	}

	/**
	 * Sets a name for the source to bind.
	 * @param name the name
	 */
	public void setName(String name) {
		this.name = name;
	}

	
	/**
	 * Returns a description of the source to bind.
	 * @return description
	 */
	public String getDescription() {
		return description;
	}

	/**
	 * Sets a description for the source to bind.
	 * @param description the description
	 */
	public void setDescription(String description) {
		this.description = description;
	}
	

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;	
		result = prime * result + ((description == null) ? 0 : description.hashCode());
		result = prime * result + ((name == null) ? 0 : name.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		Request other = (Request) obj;

		if (description == null) {
			if (other.description != null)
				return false;
		} else if (!description.equals(other.description))
			return false;	
		
		if (name == null) {
			if (other.name != null)
				return false;
		} else if (!name.equals(other.name))
			return false;	
		
		return true;
	}

}
