package org.gcube.data.fishfinder.tmplugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import org.gcube.data.fishfinder.tmplugin.requests.FishFinderRequest;
import org.gcube.data.fishfinder.tmplugin.utils.Utils;
import org.gcube.data.tmf.api.Environment;
import org.gcube.data.tmf.api.PluginLifecycle;
import org.gcube.data.tmf.api.Property;
import org.gcube.data.tmf.api.SourceBinder;
/**
 * @author "Valentina Marioli valentina.marioli@isti.cnr.it"
 *
 */
public class FishFinderPlugin implements PluginLifecycle{


	//put this information in a runtime resource
	public static String baseUrl;
	public static String extractAllCsv;
	public static String reinitialize;
	public static String jdbc;
	public static String dbLogin;
	public static String dbPassword;

	public final static String dbDriver = "org.postgresql.Driver";  
	public final static String table = "figis";
	public final static String tableUpdates = "updates";


	protected static final String REQUEST = "<fishFinderRequest>" +
			"<name required=\"true\">FishFinder</name>" +
			"<description>FAO FishFinder Collection</description>" +
			"</fishFinderRequest>";

	@Override
	public String name() {
		return "fishfinder-tm-plugin";
	}

	@Override
	public String description() {
		return "A Tree Manager plugin for FishFinder";
	}

	@Override
	public List<Property> properties() {

		return Arrays.asList(
				new Property("An example request FishFinderRequest", "requestSample", REQUEST));
	}

	@Override
	public SourceBinder binder() {	
	
		return new FishFinderBinder();
	}

	@Override
	public List<String> requestSchemas() {

		List<String> schemas = new ArrayList<String>();

		String sampleDataSchema = Utils.toSchema(FishFinderRequest.class);		
		schemas.add(sampleDataSchema);

		return schemas;
	}

	@Override
	public boolean isAnchored() {
		return false;
	}

	@Override
	public void start(Environment environment) throws Exception {

	}

	@Override
	public void stop(Environment environment) {

	}


}
