package org.gcube.data.fishfinder.tmplugin;

import static java.util.Collections.singletonList;

import java.util.List;
import java.util.UUID;

import org.gcube.data.fishfinder.tmplugin.repository.Repository;
import org.gcube.data.fishfinder.tmplugin.requests.FishFinderRequest;
import org.gcube.data.fishfinder.tmplugin.requests.RequestBinder;
import org.gcube.data.fishfinder.tmplugin.utils.Utils;
import org.gcube.data.tmf.api.SourceBinder;
import org.gcube.data.tmf.api.exceptions.InvalidRequestException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

/**
 * @author "Valentina Marioli valentina.marioli@isti.cnr.it"
 *
 */

public class FishFinderBinder implements SourceBinder {

	private static Logger log = LoggerFactory.getLogger(FishFinderBinder.class);

	private RepositoryProvider provider;

	public FishFinderBinder() {	
		this(new ProductionProvider());
		log.trace("FishFinderBinder");
	}

	//backdoor for testing
	FishFinderBinder(RepositoryProvider p) {
		provider=p;
	}

	@Override
	public List<? extends FishFinderSource> bind(Element request)
			throws InvalidRequestException, Exception {

		//get runtime resource
		if ((FishFinderPlugin.jdbc==null) || (FishFinderPlugin.dbLogin==null) || (FishFinderPlugin.dbPassword==null) || (FishFinderPlugin.baseUrl==null) || (FishFinderPlugin.extractAllCsv==null) || (FishFinderPlugin.reinitialize==null))
			Utils.getRuntimeResource();
		
		//create Table if it doesn't exist
		Utils.createTableUpdates();
		Utils.createTableFigis();
		
		//parse parameters
		FishFinderRequest fishFinderRequestRequest = new RequestBinder().bind(request);
		Repository repository = provider.newRepository(fishFinderRequestRequest);

		FishFinderSource source = new FishFinderSource(UUID.randomUUID().toString());	
		//set repository name
		source.setName(fishFinderRequestRequest.getName());
		//set repository description
		source.setDescription(fishFinderRequestRequest.getDescription());		
		source.setReader(new FishFinderReader(source,repository));
		source.setLifecycle(new Lifecycle(source));

		log.trace("created source {}"+source.id());

		return singletonList(source);


	}

}
